/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.hash.HashContainerFactory;
import net.openhft.koloboke.collect.hash.ShortHashFactory;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.hash.ImmutableLHashShortSetGO;
import net.openhft.koloboke.collect.impl.hash.LHashCapacities;
import net.openhft.koloboke.collect.impl.hash.LHashShortSetFactorySO;
import net.openhft.koloboke.collect.impl.hash.MutableLHashShortSetGO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVShortLHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableLHashShortSetGO;
import net.openhft.koloboke.collect.set.hash.HashShortSet;
import net.openhft.koloboke.collect.set.hash.HashShortSetFactory;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.Predicate;
import net.openhft.koloboke.function.ShortConsumer;

public abstract class LHashShortSetFactoryGO
extends LHashShortSetFactorySO {
    public LHashShortSetFactoryGO(HashConfig hashConf, int defaultExpectedSize, short lower, short upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashShortSetFactory thisWith(HashConfig var1, int var2, short var3, short var4);

    abstract HashShortSetFactory lHashLikeThisWith(HashConfig var1, int var2, short var3, short var4);

    abstract HashShortSetFactory qHashLikeThisWith(HashConfig var1, int var2, short var3, short var4);

    public final HashShortSetFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashShortSetFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public String toString() {
        return "HashShortSetFactory[" + this.commonString() + this.keySpecialString() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashShortSetFactory) {
            HashShortSetFactory factory = (HashShortSetFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((ShortHashFactory)factory);
        }
        return false;
    }

    public int hashCode() {
        return this.keySpecialHashCode(this.commonHashCode());
    }

    private UpdatableLHashShortSetGO shrunk(UpdatableLHashShortSetGO set) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test((Object)set)) {
            set.shrink();
        }
        return set;
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet() {
        return this.newUpdatableSet(this.getDefaultExpectedSize());
    }

    @Nonnull
    public MutableLHashShortSetGO newMutableSet() {
        return this.newMutableSet(this.getDefaultExpectedSize());
    }

    private static int sizeOr(Iterable elems, int defaultSize) {
        return elems instanceof Collection ? ((Collection)elems).size() : defaultSize;
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Iterable<Short> elements) {
        return this.newUpdatableSet((Iterable)elements, LHashShortSetFactoryGO.sizeOr(elements, this.getDefaultExpectedSize()));
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2) {
        long expectedSize = LHashShortSetFactoryGO.sizeOr(elems1, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, Containers.sizeAsInt(expectedSize += (long)LHashShortSetFactoryGO.sizeOr(elems2, 0)));
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3) {
        long expectedSize = LHashShortSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashShortSetFactoryGO.sizeOr(elems2, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, Containers.sizeAsInt(expectedSize += (long)LHashShortSetFactoryGO.sizeOr(elems3, 0)));
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4) {
        long expectedSize = LHashShortSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashShortSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)LHashShortSetFactoryGO.sizeOr(elems3, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, Containers.sizeAsInt(expectedSize += (long)LHashShortSetFactoryGO.sizeOr(elems4, 0)));
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, Iterable<Short> elems5) {
        long expectedSize = LHashShortSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashShortSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)LHashShortSetFactoryGO.sizeOr(elems3, 0);
        expectedSize += (long)LHashShortSetFactoryGO.sizeOr(elems4, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, Containers.sizeAsInt(expectedSize += (long)LHashShortSetFactoryGO.sizeOr(elems5, 0)));
    }

    @Override
    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Iterable<Short> elements, int expectedSize) {
        return this.shrunk((UpdatableLHashShortSetGO)super.newUpdatableSet((Iterable)elements, expectedSize));
    }

    private static void addAll(UpdatableLHashShortSetGO set, Iterable<? extends Short> elems) {
        if (elems instanceof Collection) {
            set.addAll((Collection)elems);
        } else {
            Iterator<? extends Short> iterator = elems.iterator();
            while (iterator.hasNext()) {
                short e = iterator.next();
                set.add(e);
            }
        }
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2, int expectedSize) {
        UpdatableLHashShortSetGO set = this.newUpdatableSet(expectedSize);
        LHashShortSetFactoryGO.addAll(set, elems1);
        LHashShortSetFactoryGO.addAll(set, elems2);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize) {
        UpdatableLHashShortSetGO set = this.newUpdatableSet(expectedSize);
        LHashShortSetFactoryGO.addAll(set, elems1);
        LHashShortSetFactoryGO.addAll(set, elems2);
        LHashShortSetFactoryGO.addAll(set, elems3);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, int expectedSize) {
        UpdatableLHashShortSetGO set = this.newUpdatableSet(expectedSize);
        LHashShortSetFactoryGO.addAll(set, elems1);
        LHashShortSetFactoryGO.addAll(set, elems2);
        LHashShortSetFactoryGO.addAll(set, elems3);
        LHashShortSetFactoryGO.addAll(set, elems4);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize) {
        UpdatableLHashShortSetGO set = this.newUpdatableSet(expectedSize);
        LHashShortSetFactoryGO.addAll(set, elems1);
        LHashShortSetFactoryGO.addAll(set, elems2);
        LHashShortSetFactoryGO.addAll(set, elems3);
        LHashShortSetFactoryGO.addAll(set, elems4);
        LHashShortSetFactoryGO.addAll(set, elems5);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Iterator<Short> elements) {
        return this.newUpdatableSet((Iterator)elements, this.getDefaultExpectedSize());
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Iterator<Short> elements, int expectedSize) {
        UpdatableLHashShortSetGO set = this.newUpdatableSet(expectedSize);
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Consumer<ShortConsumer> elementsSupplier) {
        return this.newUpdatableSet((Consumer)elementsSupplier, this.getDefaultExpectedSize());
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Consumer<ShortConsumer> elementsSupplier, int expectedSize) {
        final UpdatableLHashShortSetGO set = this.newUpdatableSet(expectedSize);
        elementsSupplier.accept((Object)new ShortConsumer(){

            public void accept(short e) {
                set.add(e);
            }
        });
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(short[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(short[] elements, int expectedSize) {
        UpdatableLHashShortSetGO set = this.newUpdatableSet(expectedSize);
        for (short e : elements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Short[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Short[] elements, int expectedSize) {
        UpdatableLHashShortSetGO set = this.newUpdatableSet(expectedSize);
        Short[] shortArray = elements;
        int n = shortArray.length;
        for (int i = 0; i < n; ++i) {
            short e = shortArray[i];
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSetOf(short e1) {
        UpdatableLHashShortSetGO set = this.newUpdatableSet(1);
        set.add(e1);
        return set;
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSetOf(short e1, short e2) {
        UpdatableLHashShortSetGO set = this.newUpdatableSet(2);
        set.add(e1);
        set.add(e2);
        return set;
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSetOf(short e1, short e2, short e3) {
        UpdatableLHashShortSetGO set = this.newUpdatableSet(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return set;
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSetOf(short e1, short e2, short e3, short e4) {
        UpdatableLHashShortSetGO set = this.newUpdatableSet(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return set;
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSetOf(short e1, short e2, short e3, short e4, short e5, short ... restElements) {
        UpdatableLHashShortSetGO set = this.newUpdatableSet(5 + restElements.length);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        for (short e : restElements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public HashShortSet newMutableSet(Iterable<Short> elements, int expectedSize) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2, int expectedSize) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, int expectedSize) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Iterable<Short> elements) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, Iterable<Short> elems5) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Iterator<Short> elements) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Iterator<Short> elements, int expectedSize) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Consumer<ShortConsumer> elementsSupplier) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Consumer<ShortConsumer> elementsSupplier, int expectedSize) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(short[] elements) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(short[] elements, int expectedSize) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Short[] elements) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSet(Short[] elements, int expectedSize) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSetOf(short e1) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSetOf(short e1, short e2) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSetOf(short e1, short e2, short e3) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSetOf(short e1, short e2, short e3, short e4) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    @Nonnull
    public HashShortSet newMutableSetOf(short e1, short e2, short e3, short e4, short e5, short ... restElements) {
        MutableLHashShortSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Iterable<Short> elements, int expectedSize) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2, int expectedSize) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, int expectedSize) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, int expectedSize) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, Iterable<Short> elems5, int expectedSize) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Iterable<Short> elements) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Iterable<Short> elems1, Iterable<Short> elems2, Iterable<Short> elems3, Iterable<Short> elems4, Iterable<Short> elems5) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Iterator<Short> elements) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Iterator<Short> elements, int expectedSize) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Consumer<ShortConsumer> elementsSupplier) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Consumer<ShortConsumer> elementsSupplier, int expectedSize) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVShortLHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(short[] elements) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(short[] elements, int expectedSize) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Short[] elements) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSet(Short[] elements, int expectedSize) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSetOf(short e1) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSetOf(short e1, short e2) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSetOf(short e1, short e2, short e3) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSetOf(short e1, short e2, short e3, short e4) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    @Nonnull
    public HashShortSet newImmutableSetOf(short e1, short e2, short e3, short e4, short e5, short ... restElements) {
        ImmutableLHashShortSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }
}

