/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.LongCollection;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.hash.ImmutableLHashLongSet;
import net.openhft.koloboke.collect.impl.hash.ImmutableLHashLongSetGO;
import net.openhft.koloboke.collect.impl.hash.LongLHashFactory;
import net.openhft.koloboke.collect.impl.hash.MutableLHashLongSet;
import net.openhft.koloboke.collect.impl.hash.MutableLHashLongSetGO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVLongLHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableLHashLongSet;
import net.openhft.koloboke.collect.impl.hash.UpdatableLHashLongSetGO;
import net.openhft.koloboke.collect.set.hash.HashLongSetFactory;

public abstract class LHashLongSetFactorySO
extends LongLHashFactory
implements HashLongSetFactory {
    LHashLongSetFactorySO(HashConfig hashConf, int defaultExpectedSize, long lower, long upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    MutableLHashLongSetGO uninitializedMutableSet() {
        return new MutableLHashLongSet();
    }

    UpdatableLHashLongSetGO uninitializedUpdatableSet() {
        return new UpdatableLHashLongSet();
    }

    ImmutableLHashLongSetGO uninitializedImmutableSet() {
        return new ImmutableLHashLongSet();
    }

    @Nonnull
    public MutableLHashLongSetGO newMutableSet(int expectedSize) {
        MutableLHashLongSet set = new MutableLHashLongSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    @Nonnull
    public UpdatableLHashLongSetGO newUpdatableSet(int expectedSize) {
        UpdatableLHashLongSet set = new UpdatableLHashLongSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    @Nonnull
    public UpdatableLHashLongSetGO newUpdatableSet(Iterable<Long> elements, int expectedSize) {
        if (elements instanceof LongCollection) {
            SeparateKVLongLHash hash;
            if (elements instanceof SeparateKVLongLHash && (hash = (SeparateKVLongLHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableLHashLongSet set = new UpdatableLHashLongSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableLHashLongSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableLHashLongSetGO set = this.newUpdatableSet(size);
        for (long e : elements) {
            set.add(e);
        }
        return set;
    }
}

