/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import net.openhft.koloboke.collect.impl.PrimitiveConstants;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.HashConfigWrapper;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHash;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVShortQHash;

public abstract class ImmutableSeparateKVShortQHashSO
extends ImmutableQHash
implements SeparateKVShortQHash,
PrimitiveConstants,
UnsafeConstants {
    short freeValue;
    short[] set;

    void copy(SeparateKVShortQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = (short[])hash.keys().clone();
    }

    void move(SeparateKVShortQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = hash.keys();
    }

    final void init(HashConfigWrapper configWrapper, int size, short freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public short freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public short removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Short)key);
    }

    public boolean contains(short key) {
        return this.index(key) >= 0;
    }

    int index(short key) {
        short free = this.freeValue;
        if (key != free) {
            short[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVShortKeyMixing.mix(key) % capacity;
            short cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 2;
            }
        }
        return -1;
    }
}

