/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.impl.hash.ImmutableSeparateKVObjLHashSO;
import net.openhft.koloboke.collect.impl.hash.ObjHash;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.Predicate;

public abstract class ImmutableSeparateKVObjLHashGO<E>
extends ImmutableSeparateKVObjLHashSO<E> {
    @Override
    @Nonnull
    public Object[] keys() {
        return this.set;
    }

    @Override
    public int capacity() {
        return this.set.length;
    }

    public void forEach(Consumer<? super E> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key);
        }
    }

    public boolean forEachWhile(Predicate<? super E> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || predicate.test(key)) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    public boolean allContainingIn(ObjCollection<?> c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(ObjCollection<? super E> c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            changed |= c.add(key);
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(ObjSet<?> s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            changed |= s.remove(key);
        }
        return changed;
    }

    public ObjIterator<E> iterator() {
        return new NoRemovedIterator();
    }

    public ObjCursor<E> setCursor() {
        return new NoRemovedCursor();
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            result[resultIndex++] = key;
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            a[resultIndex++] = key;
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            hashCode += this.nullableKeyHashCode(key);
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            sb.append(' ').append(key != this ? key : "(this Collection)").append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(E var1);

    public boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashObjSet<E> thisC, @Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    boolean retainAll(@Nonnull HashObjSet<E> thisC, @Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedCursor
    implements ObjCursor<E> {
        final E[] keys;
        int index;
        Object curKey;

        NoRemovedCursor() {
            this.keys = ImmutableSeparateKVObjLHashGO.this.set;
            this.index = this.keys.length;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            E[] keys = this.keys;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public E elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            E[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedIterator
    implements ObjIterator<E> {
        final E[] keys;
        int nextIndex;
        E next;

        NoRemovedIterator() {
            this.keys = ImmutableSeparateKVObjLHashGO.this.set;
            Object[] keys = this.keys;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super E> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            E[] keys = this.keys;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public E next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                E[] keys = this.keys;
                Object prev = this.next;
                while (--nextI >= 0) {
                    Object key = keys[nextI];
                    if (key == ObjHash.FREE) continue;
                    this.next = key;
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

