/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.LongCollection;
import net.openhft.koloboke.collect.LongCursor;
import net.openhft.koloboke.collect.LongIterator;
import net.openhft.koloboke.collect.impl.hash.ImmutableSeparateKVLongQHashSO;
import net.openhft.koloboke.collect.set.LongSet;
import net.openhft.koloboke.collect.set.hash.HashLongSet;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.LongConsumer;
import net.openhft.koloboke.function.LongPredicate;
import net.openhft.koloboke.function.Predicate;

public abstract class ImmutableSeparateKVLongQHashGO
extends ImmutableSeparateKVLongQHashSO {
    @Override
    @Nonnull
    public long[] keys() {
        return this.set;
    }

    @Override
    public int capacity() {
        return this.set.length;
    }

    public void forEach(Consumer<? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept((Object)key);
        }
    }

    public void forEach(LongConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept(key);
        }
    }

    public boolean forEachWhile(LongPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free || predicate.test(key)) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    public boolean allContainingIn(LongCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(LongCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            changed |= c.add(key);
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(LongSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            changed |= s.removeLong(key);
        }
        return changed;
    }

    public LongIterator iterator() {
        return new NoRemovedIterator();
    }

    public LongCursor setCursor() {
        return new NoRemovedCursor();
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public long[] toLongArray() {
        int size = this.size();
        long[] result = new long[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        return result;
    }

    @Nonnull
    public long[] toArray(long[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new long[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0L;
            }
            return a;
        }
        int resultIndex = 0;
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0L;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            hashCode += (int)(key ^ key >>> 32);
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            sb.append(' ').append(key).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(long var1);

    public boolean removeIf(Predicate<? super Long> filter) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(LongPredicate filter) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        throw new UnsupportedOperationException();
    }

    boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof LongCollection) {
            return this.retainAll(thisC, (LongCollection)c);
        }
        throw new UnsupportedOperationException();
    }

    private boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedCursor
    implements LongCursor {
        final long[] keys;
        final long free;
        int index;
        long curKey;

        NoRemovedCursor() {
            long free;
            this.keys = ImmutableSeparateKVLongQHashGO.this.set;
            this.index = this.keys.length;
            this.curKey = free = (this.free = ImmutableSeparateKVLongQHashGO.this.freeValue);
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            long free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedIterator
    implements LongIterator {
        final long[] keys;
        final long free;
        int nextIndex;
        long next;

        NoRemovedIterator() {
            this.keys = ImmutableSeparateKVLongQHashGO.this.set;
            long[] keys = ImmutableSeparateKVLongQHashGO.this.set;
            long free = this.free = ImmutableSeparateKVLongQHashGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] keys = this.keys;
                long free = this.free;
                long prev = this.next;
                while (--nextI >= 0) {
                    long key = keys[nextI];
                    if (key == free) continue;
                    this.next = key;
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Object)key);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

