/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import net.openhft.koloboke.collect.impl.PrimitiveConstants;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHash;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVFloatQHash;

public abstract class ImmutableSeparateKVFloatQHashSO
extends ImmutableQHash
implements SeparateKVFloatQHash,
PrimitiveConstants,
UnsafeConstants {
    int[] set;

    void copy(SeparateKVFloatQHash hash) {
        super.copy(hash);
        this.set = (int[])hash.keys().clone();
    }

    void move(SeparateKVFloatQHash hash) {
        super.copy(hash);
        this.set = hash.keys();
    }

    public boolean contains(Object key) {
        return this.contains(((Float)key).floatValue());
    }

    public boolean contains(float key) {
        return this.index(Float.floatToIntBits(key)) >= 0;
    }

    public boolean contains(int key) {
        return this.index(key) >= 0;
    }

    int index(int key) {
        int[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVFloatKeyMixing.mix(key) % capacity;
        int cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur == 0x7FFFFFFE) {
            return -1;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = keys[bIndex]) == key) {
                return bIndex;
            }
            if (cur == 0x7FFFFFFE) {
                return -1;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = keys[fIndex]) == key) {
                return fIndex;
            }
            if (cur == 0x7FFFFFFE) {
                return -1;
            }
            step += 2;
        }
    }
}

