/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import net.openhft.koloboke.collect.impl.PrimitiveConstants;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.HashConfigWrapper;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHash;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVCharQHash;

public abstract class ImmutableSeparateKVCharQHashSO
extends ImmutableQHash
implements SeparateKVCharQHash,
PrimitiveConstants,
UnsafeConstants {
    char freeValue;
    char[] set;

    void copy(SeparateKVCharQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = (char[])hash.keys().clone();
    }

    void move(SeparateKVCharQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = hash.keys();
    }

    final void init(HashConfigWrapper configWrapper, int size, char freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public char freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public char removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains(((Character)key).charValue());
    }

    public boolean contains(char key) {
        return this.index(key) >= 0;
    }

    int index(char key) {
        char free = this.freeValue;
        if (key != free) {
            char[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVCharKeyMixing.mix(key) % capacity;
            char cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 2;
            }
        }
        return -1;
    }
}

