/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.ByteCollection;
import net.openhft.koloboke.collect.ByteCursor;
import net.openhft.koloboke.collect.ByteIterator;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractByteValueView;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.CommonShortByteMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalShortByteMapOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHashSeparateKVShortByteMapSO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVShortByteQHash;
import net.openhft.koloboke.collect.map.ShortByteCursor;
import net.openhft.koloboke.collect.set.ByteSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiFunction;
import net.openhft.koloboke.function.ByteBinaryOperator;
import net.openhft.koloboke.function.ByteConsumer;
import net.openhft.koloboke.function.BytePredicate;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.Function;
import net.openhft.koloboke.function.Predicate;
import net.openhft.koloboke.function.ShortByteConsumer;
import net.openhft.koloboke.function.ShortBytePredicate;
import net.openhft.koloboke.function.ShortByteToByteFunction;
import net.openhft.koloboke.function.ShortToByteFunction;

public class ImmutableQHashSeparateKVShortByteMapGO
extends ImmutableQHashSeparateKVShortByteMapSO {
    @Override
    final void copy(SeparateKVShortByteQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVShortByteQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(short key, byte value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Byte get(Object key) {
        int index = this.index((Short)key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public byte get(short key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Byte getOrDefault(Object key, Byte defaultValue) {
        int index = this.index((Short)key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public byte getOrDefault(short key, byte defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Short, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        short[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            action.accept((Object)key, (Object)vals[i]);
        }
    }

    public void forEach(ShortByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        short[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
    }

    public boolean forEachWhile(ShortBytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        short free = this.freeValue;
        short[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ShortByteCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonShortByteMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalShortByteMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        short free = this.freeValue;
        short[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalShortByteMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        short[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Short, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        short free = this.freeValue;
        short[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            hashCode += key ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        short free = this.freeValue;
        short[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Byte put(Short key, Byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte put(short key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte putIfAbsent(Short key, Byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte putIfAbsent(short key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(short key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte compute(Short key, BiFunction<? super Short, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte compute(short key, ShortByteToByteFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte computeIfAbsent(Short key, Function<? super Short, ? extends Byte> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte computeIfAbsent(short key, ShortToByteFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte computeIfPresent(Short key, BiFunction<? super Short, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte computeIfPresent(short key, ShortByteToByteFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte merge(Short key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte merge(short key, byte value, ByteBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte addValue(short key, byte value) {
        throw new UnsupportedOperationException();
    }

    public byte addValue(short key, byte addition, byte defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Short, ? extends Byte> m) {
        CommonShortByteMapOps.putAll(this, m);
    }

    @Override
    public Byte replace(Short key, Byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte replace(short key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Short key, Byte oldValue, Byte newValue) {
        return this.replace((short)key, (byte)oldValue, (byte)newValue);
    }

    @Override
    public boolean replace(short key, byte oldValue, byte newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Short, ? super Byte, ? extends Byte> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ShortByteToByteFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(short key) {
        throw new UnsupportedOperationException();
    }

    public byte remove(short key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Short)key, (Byte)value);
    }

    public boolean remove(short key, byte value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ShortBytePredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ShortByteCursor {
        final short[] keys;
        final byte[] vals;
        final short free;
        int index;
        short curKey;
        byte curValue;

        NoRemovedMapCursor() {
            short free;
            this.keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue);
        }

        public void forEachForward(ShortByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            byte[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short key() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            short[] keys = this.keys;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        final short[] keys;
        final byte[] vals;
        final short free;
        int index;
        short curKey;
        byte curValue;

        NoRemovedValueCursor() {
            short free;
            this.keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue);
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            byte[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            short[] keys = this.keys;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        final short[] keys;
        final byte[] vals;
        final short free;
        int nextIndex;
        byte next;

        NoRemovedValueIterator() {
            this.keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            short free = this.free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                short[] keys = this.keys;
                short free = this.free;
                byte prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            byte[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Object)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            byte[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Short, Byte>> {
        final short[] keys;
        final byte[] vals;
        final short free;
        int index;
        short curKey;
        byte curValue;

        NoRemovedEntryCursor() {
            short free;
            this.keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Short, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            byte[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept((Object)new ImmutableEntry(key, vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Short, Byte> elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            short[] keys = this.keys;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Short, Byte>> {
        final short[] keys;
        final byte[] vals;
        final short free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            short free = this.free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                short key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Short, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            byte[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept((Object)new ImmutableEntry(key, vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Short, Byte> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                short[] keys = this.keys;
                short free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    short key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableQHashSeparateKVShortByteMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVShortByteMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableQHashSeparateKVShortByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return ImmutableQHashSeparateKVShortByteMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Object)vals[i]);
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeByte(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public ByteCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return ImmutableQHashSeparateKVShortByteMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            ImmutableQHashSeparateKVShortByteMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Byte> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(BytePredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ShortByteEntry {
        private short key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(short key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ShortByteEntry {
        private final short key;
        private final byte value;

        ImmutableEntry(short key, byte value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    abstract class ShortByteEntry
    extends AbstractEntry<Short, Byte> {
        ShortByteEntry() {
        }

        abstract short key();

        @Override
        public final Short getKey() {
            return this.key();
        }

        abstract byte value();

        @Override
        public final Byte getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                short k2 = (Short)e2.getKey();
                byte v2 = (Byte)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Short, Byte>>
    implements HashObjSet<Map.Entry<Short, Byte>>,
    InternalObjCollectionOps<Map.Entry<Short, Byte>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Short, Byte>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashSeparateKVShortByteMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableQHashSeparateKVShortByteMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableQHashSeparateKVShortByteMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashSeparateKVShortByteMapGO.this.containsEntry((Short)e.getKey(), (Byte)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Short, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept((Object)new ImmutableEntry(key, vals[i]));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Short, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || predicate.test((Object)new ImmutableEntry(key, vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Short, Byte>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Short, Byte>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Short, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableQHashSeparateKVShortByteMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            short free = ImmutableQHashSeparateKVShortByteMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortByteMapGO.this.set;
            byte[] vals = ImmutableQHashSeparateKVShortByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVShortByteMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                short key = (Short)e.getKey();
                byte value = (Byte)e.getValue();
                return ImmutableQHashSeparateKVShortByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Short, Byte>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableQHashSeparateKVShortByteMapGO.this.clear();
        }
    }
}

