/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.ShortCollection;
import net.openhft.koloboke.collect.ShortCursor;
import net.openhft.koloboke.collect.ShortIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.AbstractShortValueView;
import net.openhft.koloboke.collect.impl.CommonDoubleShortMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalDoubleShortMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHashSeparateKVDoubleShortMapSO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVDoubleShortQHash;
import net.openhft.koloboke.collect.map.DoubleShortCursor;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.ShortSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiFunction;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.DoubleShortConsumer;
import net.openhft.koloboke.function.DoubleShortPredicate;
import net.openhft.koloboke.function.DoubleShortToShortFunction;
import net.openhft.koloboke.function.DoubleToShortFunction;
import net.openhft.koloboke.function.Function;
import net.openhft.koloboke.function.Predicate;
import net.openhft.koloboke.function.ShortBinaryOperator;
import net.openhft.koloboke.function.ShortConsumer;
import net.openhft.koloboke.function.ShortPredicate;

public class ImmutableQHashSeparateKVDoubleShortMapGO
extends ImmutableQHashSeparateKVDoubleShortMapSO {
    @Override
    final void copy(SeparateKVDoubleShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVDoubleShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public short defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(double key, short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public boolean containsEntry(long key, short value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Short get(Object key) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public short get(double key) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Short getOrDefault(Object key, Short defaultValue) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public short getOrDefault(double key, short defaultValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Double, ? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept((Object)Double.longBitsToDouble(key), (Object)vals[i]);
        }
    }

    public void forEach(DoubleShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept(Double.longBitsToDouble(key), vals[i]);
        }
    }

    public boolean forEachWhile(DoubleShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(key), vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public DoubleShortCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonDoubleShortMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalDoubleShortMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalDoubleShortMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Double, Short>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ShortCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            hashCode += (int)(key ^ key >>> 32) ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            sb.append(' ');
            sb.append(Double.longBitsToDouble(key));
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Short put(Double key, Short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short put(double key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short putIfAbsent(Double key, Short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short putIfAbsent(double key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(double key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(long key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short compute(Double key, BiFunction<? super Double, ? super Short, ? extends Short> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short compute(double key, DoubleShortToShortFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short computeIfAbsent(Double key, Function<? super Double, ? extends Short> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short computeIfAbsent(double key, DoubleToShortFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short computeIfPresent(Double key, BiFunction<? super Double, ? super Short, ? extends Short> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short computeIfPresent(double key, DoubleShortToShortFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short merge(Double key, Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short merge(double key, short value, ShortBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short addValue(double key, short value) {
        throw new UnsupportedOperationException();
    }

    public short addValue(double key, short addition, short defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Double, ? extends Short> m) {
        CommonDoubleShortMapOps.putAll(this, m);
    }

    @Override
    public Short replace(Double key, Short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short replace(double key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Double key, Short oldValue, Short newValue) {
        return this.replace((double)key, (short)oldValue, (short)newValue);
    }

    @Override
    public boolean replace(double key, short oldValue, short newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Double, ? super Short, ? extends Short> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(DoubleShortToShortFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(double key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(long key) {
        throw new UnsupportedOperationException();
    }

    public short remove(double key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Double)key, (Short)value);
    }

    public boolean remove(double key, short value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(DoubleShortPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements DoubleShortCursor {
        final long[] keys;
        final short[] vals;
        int index;
        long curKey;
        short curValue;

        NoRemovedMapCursor() {
            this.keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key), vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double key() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey == 0x7FFFFFFFFFFFFFFEL) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ShortCursor {
        final long[] keys;
        final short[] vals;
        int index;
        long curKey;
        short curValue;

        NoRemovedValueCursor() {
            this.keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public short elem() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ShortIterator {
        final long[] keys;
        final short[] vals;
        int nextIndex;
        short next;

        NoRemovedValueIterator() {
            this.keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] keys = this.keys;
                short prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Object)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Double, Short>> {
        final long[] keys;
        final short[] vals;
        int index;
        long curKey;
        short curValue;

        NoRemovedEntryCursor() {
            this.keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(Consumer<? super Map.Entry<Double, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Object)new ImmutableEntry(key, vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public Map.Entry<Double, Short> elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Double, Short>> {
        final long[] keys;
        final short[] vals;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Double, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Object)new ImmutableEntry(key, vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Double, Short> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] keys = this.keys;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    long key = keys[nextI];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractShortValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableQHashSeparateKVDoubleShortMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVDoubleShortMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableQHashSeparateKVDoubleShortMapGO.this.containsValue(o);
        }

        public boolean contains(short v) {
            return ImmutableQHashSeparateKVDoubleShortMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Short> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Object)vals[i]);
            }
        }

        public void forEach(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(ShortPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ShortCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ShortCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ShortSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeShort(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public ShortIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public ShortCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public short[] toArray(short[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new short[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeShort((Short)o);
        }

        public boolean removeShort(short v) {
            return ImmutableQHashSeparateKVDoubleShortMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            ImmutableQHashSeparateKVDoubleShortMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(ShortPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends DoubleShortEntry {
        private long key;
        private short value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, short value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends DoubleShortEntry {
        private final long key;
        private final short value;

        ImmutableEntry(long key, short value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    abstract class DoubleShortEntry
    extends AbstractEntry<Double, Short> {
        DoubleShortEntry() {
        }

        abstract long key();

        @Override
        public final Double getKey() {
            return Double.longBitsToDouble(this.key());
        }

        abstract short value();

        @Override
        public final Short getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = Double.doubleToLongBits((Double)e2.getKey());
                short v2 = (Short)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Double, Short>>
    implements HashObjSet<Map.Entry<Double, Short>>,
    InternalObjCollectionOps<Map.Entry<Double, Short>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Double, Short>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashSeparateKVDoubleShortMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableQHashSeparateKVDoubleShortMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableQHashSeparateKVDoubleShortMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashSeparateKVDoubleShortMapGO.this.containsEntry((Double)e.getKey(), (short)((Short)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Double, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Object)new ImmutableEntry(key, vals[i]));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Double, Short>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test((Object)new ImmutableEntry(key, vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Double, Short>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Double, Short>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Double, Short>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableQHashSeparateKVDoubleShortMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long[] keys = ImmutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ');
                sb.append(Double.longBitsToDouble(key));
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVDoubleShortMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                double key = (Double)e.getKey();
                short value = (Short)e.getValue();
                return ImmutableQHashSeparateKVDoubleShortMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Double, Short>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableQHashSeparateKVDoubleShortMapGO.this.clear();
        }
    }
}

