/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.ByteCollection;
import net.openhft.koloboke.collect.ByteCursor;
import net.openhft.koloboke.collect.ByteIterator;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractByteValueView;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjByteMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalObjByteMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.ImmutableLHashSeparateKVObjByteMapSO;
import net.openhft.koloboke.collect.impl.hash.ObjHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVObjByteLHash;
import net.openhft.koloboke.collect.map.ObjByteCursor;
import net.openhft.koloboke.collect.set.ByteSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiFunction;
import net.openhft.koloboke.function.ByteBinaryOperator;
import net.openhft.koloboke.function.ByteConsumer;
import net.openhft.koloboke.function.BytePredicate;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.Function;
import net.openhft.koloboke.function.ObjByteConsumer;
import net.openhft.koloboke.function.ObjBytePredicate;
import net.openhft.koloboke.function.ObjByteToByteFunction;
import net.openhft.koloboke.function.Predicate;
import net.openhft.koloboke.function.ToByteFunction;

public class ImmutableLHashSeparateKVObjByteMapGO<K>
extends ImmutableLHashSeparateKVObjByteMapSO<K> {
    @Override
    final void copy(SeparateKVObjByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(Object key, byte value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Byte get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public byte getByte(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Byte getOrDefault(Object key, Byte defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public byte getOrDefault(Object key, byte defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        Object[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, (Object)vals[i]);
        }
    }

    @Override
    public void forEach(ObjByteConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        Object[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, vals[i]);
        }
    }

    @Override
    public boolean forEachWhile(ObjBytePredicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        Object[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ObjByteCursor<K> cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjByteMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalObjByteMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        Object[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalObjByteMapOps<? super K> m) {
        if (this.isEmpty()) {
            return;
        }
        Object[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<K, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        Object[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            hashCode += this.nullableKeyHashCode(key) ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        Object[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            sb.append(' ');
            sb.append(key != this ? key : "(this Map)");
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Byte put(K key, Byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte put(K key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte putIfAbsent(K key, Byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte putIfAbsent(K key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(K key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte compute(K key, BiFunction<? super K, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    Byte computeNullKey(BiFunction<? super K, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte compute(K key, ObjByteToByteFunction<? super K> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    byte computeNullKey(ObjByteToByteFunction<? super K> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte computeIfAbsent(K key, Function<? super K, ? extends Byte> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    Byte computeIfAbsentNullKey(Function<? super K, ? extends Byte> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte computeIfAbsent(K key, ToByteFunction<? super K> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    byte computeIfAbsentNullKey(ToByteFunction<? super K> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte computeIfPresent(K key, BiFunction<? super K, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte computeIfPresent(K key, ObjByteToByteFunction<? super K> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte merge(K key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    Byte mergeNullKey(Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte merge(K key, byte value, ByteBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    byte mergeNullKey(byte value, ByteBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte addValue(K key, byte value) {
        throw new UnsupportedOperationException();
    }

    public byte addValue(K key, byte addition, byte defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends Byte> m) {
        CommonObjByteMapOps.putAll(this, m);
    }

    @Override
    public Byte replace(K key, Byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte replace(K key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(K key, Byte oldValue, Byte newValue) {
        return this.replace(key, (byte)oldValue, (byte)newValue);
    }

    @Override
    public boolean replace(K key, byte oldValue, byte newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super Byte, ? extends Byte> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ObjByteToByteFunction<? super K> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte remove(Object key) {
        throw new UnsupportedOperationException();
    }

    Byte removeNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(Object key) {
        throw new UnsupportedOperationException();
    }

    boolean justRemoveNullKey() {
        throw new UnsupportedOperationException();
    }

    public byte removeAsByte(Object key) {
        throw new UnsupportedOperationException();
    }

    byte removeAsByteNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(key, (Byte)value);
    }

    public boolean remove(Object key, byte value) {
        throw new UnsupportedOperationException();
    }

    boolean removeEntryNullKey(byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(ObjBytePredicate<? super K> filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ObjByteCursor<K> {
        final K[] keys;
        final byte[] vals;
        int index;
        Object curKey;
        byte curValue;

        NoRemovedMapCursor() {
            this.keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjByteConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            K[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey == ObjHash.FREE) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            K[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        final K[] keys;
        final byte[] vals;
        int index;
        Object curKey;
        byte curValue;

        NoRemovedValueCursor() {
            this.keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            K[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public byte elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            K[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        final K[] keys;
        final byte[] vals;
        int nextIndex;
        byte next;

        NoRemovedValueIterator() {
            this.keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == ObjHash.FREE) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                K[] keys = this.keys;
                byte prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == ObjHash.FREE) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            K[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Object)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            K[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Byte>> {
        final K[] keys;
        final byte[] vals;
        int index;
        Object curKey;
        byte curValue;

        NoRemovedEntryCursor() {
            this.keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            K[] keys = this.keys;
            byte[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Object)new ImmutableEntry(key, vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Byte> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            K[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Byte>> {
        final K[] keys;
        final byte[] vals;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            K[] keys = this.keys;
            byte[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Object)new ImmutableEntry(key, vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Byte> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                K[] keys = this.keys;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    Object key = keys[nextI];
                    if (key == ObjHash.FREE) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableLHashSeparateKVObjByteMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVObjByteMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableLHashSeparateKVObjByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return ImmutableLHashSeparateKVObjByteMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Object)vals[i]);
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= s.removeByte(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public ByteCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return ImmutableLHashSeparateKVObjByteMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            ImmutableLHashSeparateKVObjByteMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Byte> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(BytePredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ObjByteEntry {
        private K key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ObjByteEntry {
        private final K key;
        private final byte value;

        ImmutableEntry(K key, byte value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    abstract class ObjByteEntry
    extends AbstractEntry<K, Byte> {
        ObjByteEntry() {
        }

        abstract K key();

        @Override
        public final K getKey() {
            return this.key();
        }

        abstract byte value();

        @Override
        public final Byte getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                byte v2 = (Byte)e2.getValue();
                return ImmutableLHashSeparateKVObjByteMapGO.this.nullableKeyEquals(this.key(), k2) && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return ImmutableLHashSeparateKVObjByteMapGO.this.nullableKeyHashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, Byte>>
    implements HashObjSet<Map.Entry<K, Byte>>,
    InternalObjCollectionOps<Map.Entry<K, Byte>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<K, Byte>> equivalence() {
            return Equivalence.entryEquivalence(ImmutableLHashSeparateKVObjByteMapGO.this.keyEquivalence(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashSeparateKVObjByteMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableLHashSeparateKVObjByteMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableLHashSeparateKVObjByteMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashSeparateKVObjByteMapGO.this.containsEntry(e.getKey(), (Byte)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Object)new ImmutableEntry(key, vals[i]));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || predicate.test((Object)new ImmutableEntry(key, vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<K, Byte>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, Byte>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableLHashSeparateKVObjByteMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            Object[] keys = ImmutableLHashSeparateKVObjByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVObjByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Collection)");
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVObjByteMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                byte value = (Byte)e.getValue();
                return ImmutableLHashSeparateKVObjByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, Byte>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableLHashSeparateKVObjByteMapGO.this.clear();
        }
    }
}

