/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.FloatCollection;
import net.openhft.koloboke.collect.FloatCursor;
import net.openhft.koloboke.collect.FloatIterator;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractFloatValueView;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonByteFloatMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalByteFloatMapOps;
import net.openhft.koloboke.collect.impl.InternalFloatCollectionOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.ImmutableLHashSeparateKVByteFloatMapSO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVByteFloatLHash;
import net.openhft.koloboke.collect.map.ByteFloatCursor;
import net.openhft.koloboke.collect.set.FloatSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiFunction;
import net.openhft.koloboke.function.ByteFloatConsumer;
import net.openhft.koloboke.function.ByteFloatPredicate;
import net.openhft.koloboke.function.ByteFloatToFloatFunction;
import net.openhft.koloboke.function.ByteToFloatFunction;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.FloatBinaryOperator;
import net.openhft.koloboke.function.FloatConsumer;
import net.openhft.koloboke.function.FloatPredicate;
import net.openhft.koloboke.function.Function;
import net.openhft.koloboke.function.Predicate;

public class ImmutableLHashSeparateKVByteFloatMapGO
extends ImmutableLHashSeparateKVByteFloatMapSO {
    @Override
    final void copy(SeparateKVByteFloatLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVByteFloatLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public float defaultValue() {
        return 0.0f;
    }

    @Override
    public boolean containsEntry(byte key, float value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Float.floatToIntBits(value);
        }
        return false;
    }

    @Override
    public boolean containsEntry(byte key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Float get(Object key) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return null;
    }

    public float get(byte key) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return this.defaultValue();
    }

    @Override
    public Float getOrDefault(Object key, Float defaultValue) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return defaultValue;
    }

    public float getOrDefault(byte key, float defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Byte, ? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        byte[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            action.accept((Object)key, (Object)Float.valueOf(Float.intBitsToFloat(vals[i])));
        }
    }

    public void forEach(ByteFloatConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        byte[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            action.accept(key, Float.intBitsToFloat(vals[i]));
        }
    }

    public boolean forEachWhile(ByteFloatPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        byte free = this.freeValue;
        byte[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free || predicate.test(key, Float.intBitsToFloat(vals[i]))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ByteFloatCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonByteFloatMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalByteFloatMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        byte free = this.freeValue;
        byte[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalByteFloatMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        byte[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Byte, Float>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public FloatCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        byte free = this.freeValue;
        byte[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            hashCode += key ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        byte free = this.freeValue;
        byte[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(Float.intBitsToFloat(vals[i]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Float put(Byte key, Float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float put(byte key, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float putIfAbsent(Byte key, Float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float putIfAbsent(byte key, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(byte key, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(byte key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float compute(Byte key, BiFunction<? super Byte, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float compute(byte key, ByteFloatToFloatFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float computeIfAbsent(Byte key, Function<? super Byte, ? extends Float> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float computeIfAbsent(byte key, ByteToFloatFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float computeIfPresent(Byte key, BiFunction<? super Byte, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float computeIfPresent(byte key, ByteFloatToFloatFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float merge(Byte key, Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float merge(byte key, float value, FloatBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float addValue(byte key, float value) {
        throw new UnsupportedOperationException();
    }

    public float addValue(byte key, float addition, float defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Byte, ? extends Float> m) {
        CommonByteFloatMapOps.putAll(this, m);
    }

    @Override
    public Float replace(Byte key, Float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float replace(byte key, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Byte key, Float oldValue, Float newValue) {
        return this.replace((byte)key, oldValue.floatValue(), newValue.floatValue());
    }

    @Override
    public boolean replace(byte key, float oldValue, float newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Byte, ? super Float, ? extends Float> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ByteFloatToFloatFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(byte key) {
        throw new UnsupportedOperationException();
    }

    public float remove(byte key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Byte)key, ((Float)value).floatValue());
    }

    public boolean remove(byte key, float value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ByteFloatPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ByteFloatCursor {
        final byte[] keys;
        final int[] vals;
        final byte free;
        int index;
        byte curKey;
        int curValue;

        NoRemovedMapCursor() {
            byte free;
            this.keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue);
        }

        public void forEachForward(ByteFloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            int[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(key, Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(float value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Float.floatToIntBits(value);
        }

        public boolean moveNext() {
            byte[] keys = this.keys;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements FloatCursor {
        final byte[] keys;
        final int[] vals;
        final byte free;
        int index;
        byte curKey;
        int curValue;

        NoRemovedValueCursor() {
            byte free;
            this.keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue);
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            int[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public float elem() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            byte[] keys = this.keys;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements FloatIterator {
        final byte[] keys;
        final int[] vals;
        final byte free;
        int nextIndex;
        float next;

        NoRemovedValueIterator() {
            this.keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            byte free = this.free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = Float.intBitsToFloat(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                byte[] keys = this.keys;
                byte free = this.free;
                float prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = Float.intBitsToFloat(this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            int[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Object)Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            int[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Float>> {
        final byte[] keys;
        final int[] vals;
        final byte free;
        int index;
        byte curKey;
        int curValue;

        NoRemovedEntryCursor() {
            byte free;
            this.keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            int[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Object)new ImmutableEntry(key, vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Float> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            byte[] keys = this.keys;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Float>> {
        final byte[] keys;
        final int[] vals;
        final byte free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            byte free = this.free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            int[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Object)new ImmutableEntry(key, vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Float> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                byte[] keys = this.keys;
                byte free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    byte key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractFloatValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableLHashSeparateKVByteFloatMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVByteFloatMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableLHashSeparateKVByteFloatMapGO.this.containsValue(o);
        }

        public boolean contains(float v) {
            return ImmutableLHashSeparateKVByteFloatMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(int bits) {
            return ImmutableLHashSeparateKVByteFloatMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Float> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Object)Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
        }

        public void forEach(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
        }

        public boolean forEachWhile(FloatPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(Float.intBitsToFloat(vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.allContainingIn((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(Float.intBitsToFloat(vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.reverseAddAllTo((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(Float.intBitsToFloat(vals[i]));
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(FloatSet s) {
            if (s instanceof InternalFloatCollectionOps) {
                return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeFloat(Float.intBitsToFloat(vals[i]));
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeFloat(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public FloatIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public FloatCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public float[] toFloatArray() {
            int size = this.size();
            float[] result = new float[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Float.intBitsToFloat(vals[i]);
            }
            return result;
        }

        public float[] toArray(float[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new float[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0f;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Float.intBitsToFloat(vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0f;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(Float.intBitsToFloat(vals[i])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeFloat(((Float)o).floatValue());
        }

        public boolean removeFloat(float v) {
            return ImmutableLHashSeparateKVByteFloatMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeFloat(int bits) {
            return ImmutableLHashSeparateKVByteFloatMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            ImmutableLHashSeparateKVByteFloatMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Float> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(FloatPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ByteFloatEntry {
        private byte key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(byte key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ByteFloatEntry {
        private final byte key;
        private final int value;

        ImmutableEntry(byte key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    abstract class ByteFloatEntry
    extends AbstractEntry<Byte, Float> {
        ByteFloatEntry() {
        }

        abstract byte key();

        @Override
        public final Byte getKey() {
            return this.key();
        }

        abstract int value();

        @Override
        public final Float getValue() {
            return Float.valueOf(Float.intBitsToFloat(this.value()));
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                byte k2 = (Byte)e2.getKey();
                int v2 = Float.floatToIntBits(((Float)e2.getValue()).floatValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Byte, Float>>
    implements HashObjSet<Map.Entry<Byte, Float>>,
    InternalObjCollectionOps<Map.Entry<Byte, Float>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Byte, Float>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashSeparateKVByteFloatMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableLHashSeparateKVByteFloatMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableLHashSeparateKVByteFloatMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashSeparateKVByteFloatMapGO.this.containsEntry((byte)((Byte)e.getKey()), ((Float)e.getValue()).floatValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Byte, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Object)new ImmutableEntry(key, vals[i]));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Byte, Float>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || predicate.test((Object)new ImmutableEntry(key, vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Byte, Float>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Byte, Float>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Byte, Float>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableLHashSeparateKVByteFloatMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            byte free = ImmutableLHashSeparateKVByteFloatMapGO.this.freeValue;
            byte[] keys = ImmutableLHashSeparateKVByteFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVByteFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Float.intBitsToFloat(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVByteFloatMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                byte key = (Byte)e.getKey();
                float value = ((Float)e.getValue()).floatValue();
                return ImmutableLHashSeparateKVByteFloatMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Byte, Float>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableLHashSeparateKVByteFloatMapGO.this.clear();
        }
    }
}

