/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.FloatCollection;
import net.openhft.koloboke.collect.FloatCursor;
import net.openhft.koloboke.collect.FloatIterator;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractFloatValueView;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonFloatFloatMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalFloatCollectionOps;
import net.openhft.koloboke.collect.impl.InternalFloatFloatMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.ImmutableLHashParallelKVFloatFloatMapSO;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.ParallelKVFloatFloatLHash;
import net.openhft.koloboke.collect.map.FloatFloatCursor;
import net.openhft.koloboke.collect.set.FloatSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiFunction;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.FloatBinaryOperator;
import net.openhft.koloboke.function.FloatConsumer;
import net.openhft.koloboke.function.FloatFloatConsumer;
import net.openhft.koloboke.function.FloatFloatPredicate;
import net.openhft.koloboke.function.FloatFloatToFloatFunction;
import net.openhft.koloboke.function.FloatPredicate;
import net.openhft.koloboke.function.FloatUnaryOperator;
import net.openhft.koloboke.function.Function;
import net.openhft.koloboke.function.Predicate;

public class ImmutableLHashParallelKVFloatFloatMapGO
extends ImmutableLHashParallelKVFloatFloatMapSO {
    final void copy(ParallelKVFloatFloatLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVFloatFloatLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public float defaultValue() {
        return 0.0f;
    }

    @Override
    public boolean containsEntry(float key, float value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32) == Float.floatToIntBits(value);
        }
        if (cur == 0x7FFFFFFE) {
            return false;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return (int)(entry >>> 32) == Float.floatToIntBits(value);
        } while (cur != 0x7FFFFFFE);
        return false;
    }

    @Override
    public boolean containsEntry(int key, int value) {
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(key) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == key) {
            return (int)(entry >>> 32) == value;
        }
        if (cur == 0x7FFFFFFE) {
            return false;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
            return (int)(entry >>> 32) == value;
        } while (cur != 0x7FFFFFFE);
        return false;
    }

    @Override
    public Float get(Object key) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
        }
        if (cur == 0x7FFFFFFE) {
            return null;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
        } while (cur != 0x7FFFFFFE);
        return null;
    }

    public float get(float key) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return Float.intBitsToFloat((int)(entry >>> 32));
        }
        if (cur == 0x7FFFFFFE) {
            return this.defaultValue();
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return Float.intBitsToFloat((int)(entry >>> 32));
        } while (cur != 0x7FFFFFFE);
        return this.defaultValue();
    }

    @Override
    public Float getOrDefault(Object key, Float defaultValue) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
        }
        if (cur == 0x7FFFFFFE) {
            return defaultValue;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
        } while (cur != 0x7FFFFFFE);
        return defaultValue;
    }

    public float getOrDefault(float key, float defaultValue) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return Float.intBitsToFloat((int)(entry >>> 32));
        }
        if (cur == 0x7FFFFFFE) {
            return defaultValue;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return Float.intBitsToFloat((int)(entry >>> 32));
        } while (cur != 0x7FFFFFFE);
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Float, ? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            action.accept((Object)Float.valueOf(Float.intBitsToFloat(key)), (Object)Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
        }
    }

    public void forEach(FloatFloatConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.intBitsToFloat(key), Float.intBitsToFloat((int)(entry >>> 32)));
        }
    }

    public boolean forEachWhile(FloatFloatPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat(key), Float.intBitsToFloat((int)(entry >>> 32)))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public FloatFloatCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonFloatFloatMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalFloatFloatMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE || m.containsEntry(key, (int)(entry >>> 32))) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalFloatFloatMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            m.justPut(key, (int)(entry >>> 32));
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Float, Float>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public FloatCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            hashCode += key ^ (int)(entry >>> 32);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            sb.append(' ');
            sb.append(Float.intBitsToFloat(key));
            sb.append('=');
            sb.append(Float.intBitsToFloat((int)(entry >>> 32)));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Float put(Float key, Float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float put(float key, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float putIfAbsent(Float key, Float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float putIfAbsent(float key, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(float key, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(int key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float compute(Float key, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float compute(float key, FloatFloatToFloatFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float computeIfAbsent(Float key, Function<? super Float, ? extends Float> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float computeIfAbsent(float key, FloatUnaryOperator mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float computeIfPresent(Float key, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float computeIfPresent(float key, FloatFloatToFloatFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float merge(Float key, Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float merge(float key, float value, FloatBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float addValue(float key, float value) {
        throw new UnsupportedOperationException();
    }

    public float addValue(float key, float addition, float defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Float, ? extends Float> m) {
        CommonFloatFloatMapOps.putAll(this, m);
    }

    @Override
    public Float replace(Float key, Float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float replace(float key, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Float key, Float oldValue, Float newValue) {
        return this.replace(key.floatValue(), oldValue.floatValue(), newValue.floatValue());
    }

    @Override
    public boolean replace(float key, float oldValue, float newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Float, ? super Float, ? extends Float> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(FloatFloatToFloatFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(float key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public float remove(float key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(((Float)key).floatValue(), ((Float)value).floatValue());
    }

    public boolean remove(float key, float value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(FloatFloatPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements FloatFloatCursor {
        final long[] tab;
        int index;
        int curKey;
        int curValue;

        NoRemovedMapCursor() {
            this.tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatFloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key), Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float key() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(float value) {
            if (this.curKey == 0x7FFFFFFE) {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_VALUE_OFFSET + ((long)this.index << 3), Float.floatToIntBits(value));
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            for (int i = this.index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (int)(entry >>> 32);
                return true;
            }
            this.curKey = 0x7FFFFFFE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements FloatCursor {
        final long[] tab;
        int index;
        int curKey;
        int curValue;

        NoRemovedValueCursor() {
            this.tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float elem() {
            if (this.curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            for (int i = this.index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (int)(entry >>> 32);
                return true;
            }
            this.curKey = 0x7FFFFFFE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements FloatIterator {
        final long[] tab;
        int nextIndex;
        float next;

        NoRemovedValueIterator() {
            this.tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                if ((int)entry >= 0x7FFFFFFE) continue;
                this.next = Float.intBitsToFloat((int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] tab = this.tab;
                float prev = this.next;
                while (--nextI >= 0) {
                    long entry = tab[nextI];
                    if ((int)entry >= 0x7FFFFFFE) continue;
                    this.next = Float.intBitsToFloat((int)(entry >>> 32));
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((Object)Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Float, Float>> {
        final long[] tab;
        int index;
        int curKey;
        int curValue;

        NoRemovedEntryCursor() {
            this.tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(Consumer<? super Map.Entry<Float, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Object)new ImmutableEntry(key, (int)(entry >>> 32)));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public Map.Entry<Float, Float> elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            for (int i = this.index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (int)(entry >>> 32);
                return true;
            }
            this.curKey = 0x7FFFFFFE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Float, Float>> {
        final long[] tab;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.next = new ImmutableEntry(key, (int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Float, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Object)new ImmutableEntry(key, (int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Float, Float> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] tab = this.tab;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    long entry = tab[nextI];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.next = new ImmutableEntry(key, (int)(entry >>> 32));
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractFloatValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableLHashParallelKVFloatFloatMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashParallelKVFloatFloatMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableLHashParallelKVFloatFloatMapGO.this.containsValue(o);
        }

        public boolean contains(float v) {
            return ImmutableLHashParallelKVFloatFloatMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(int bits) {
            return ImmutableLHashParallelKVFloatFloatMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Float> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((Object)Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
            }
        }

        public void forEach(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
        }

        public boolean forEachWhile(FloatPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.allContainingIn((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || c.contains(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || c.contains((int)(entry >>> 32))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.reverseAddAllTo((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= c.add(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= c.add((int)(entry >>> 32));
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(FloatSet s) {
            if (s instanceof InternalFloatCollectionOps) {
                return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= s.removeFloat(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= s.removeFloat((int)(entry >>> 32));
            }
            return changed;
        }

        @Nonnull
        public FloatIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public FloatCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                result[resultIndex++] = Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                a[resultIndex++] = Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public float[] toFloatArray() {
            int size = this.size();
            float[] result = new float[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                result[resultIndex++] = Float.intBitsToFloat((int)(entry >>> 32));
            }
            return result;
        }

        public float[] toArray(float[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new float[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0f;
                }
                return a;
            }
            int resultIndex = 0;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                a[resultIndex++] = Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0f;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                sb.append(' ').append(Float.intBitsToFloat((int)(entry >>> 32))).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeFloat(((Float)o).floatValue());
        }

        public boolean removeFloat(float v) {
            return ImmutableLHashParallelKVFloatFloatMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeFloat(int bits) {
            return ImmutableLHashParallelKVFloatFloatMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            ImmutableLHashParallelKVFloatFloatMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Float> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(FloatPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends FloatFloatEntry {
        private int key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends FloatFloatEntry {
        private final int key;
        private final int value;

        ImmutableEntry(int key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    abstract class FloatFloatEntry
    extends AbstractEntry<Float, Float> {
        FloatFloatEntry() {
        }

        abstract int key();

        @Override
        public final Float getKey() {
            return Float.valueOf(Float.intBitsToFloat(this.key()));
        }

        abstract int value();

        @Override
        public final Float getValue() {
            return Float.valueOf(Float.intBitsToFloat(this.value()));
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = Float.floatToIntBits(((Float)e2.getKey()).floatValue());
                int v2 = Float.floatToIntBits(((Float)e2.getValue()).floatValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Float, Float>>
    implements HashObjSet<Map.Entry<Float, Float>>,
    InternalObjCollectionOps<Map.Entry<Float, Float>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Float, Float>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashParallelKVFloatFloatMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableLHashParallelKVFloatFloatMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableLHashParallelKVFloatFloatMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashParallelKVFloatFloatMapGO.this.containsEntry(((Float)e.getKey()).floatValue(), ((Float)e.getValue()).floatValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                result[resultIndex++] = new ImmutableEntry(key, (int)(entry >>> 32));
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                a[resultIndex++] = new ImmutableEntry(key, (int)(entry >>> 32));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Float, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Object)new ImmutableEntry(key, (int)(entry >>> 32)));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Float, Float>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || predicate.test((Object)new ImmutableEntry(key, (int)(entry >>> 32)))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Float, Float>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Float, Float>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                changed |= s.remove((Object)e.with(key, (int)(entry >>> 32)));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Float, Float>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                changed |= c.add((Object)new ImmutableEntry(key, (int)(entry >>> 32)));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableLHashParallelKVFloatFloatMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long[] tab = ImmutableLHashParallelKVFloatFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                sb.append(' ');
                sb.append(Float.intBitsToFloat(key));
                sb.append('=');
                sb.append(Float.intBitsToFloat((int)(entry >>> 32)));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashParallelKVFloatFloatMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                float key = ((Float)e.getKey()).floatValue();
                float value = ((Float)e.getValue()).floatValue();
                return ImmutableLHashParallelKVFloatFloatMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Float, Float>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableLHashParallelKVFloatFloatMapGO.this.clear();
        }
    }
}

