/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.ByteCollection;
import net.openhft.koloboke.collect.ByteCursor;
import net.openhft.koloboke.collect.ByteIterator;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractByteValueView;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonByteByteMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalByteByteMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.ImmutableLHashParallelKVByteByteMapSO;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.ParallelKVByteByteLHash;
import net.openhft.koloboke.collect.map.ByteByteCursor;
import net.openhft.koloboke.collect.set.ByteSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiFunction;
import net.openhft.koloboke.function.ByteBinaryOperator;
import net.openhft.koloboke.function.ByteByteConsumer;
import net.openhft.koloboke.function.ByteBytePredicate;
import net.openhft.koloboke.function.ByteByteToByteFunction;
import net.openhft.koloboke.function.ByteConsumer;
import net.openhft.koloboke.function.BytePredicate;
import net.openhft.koloboke.function.ByteUnaryOperator;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.Function;
import net.openhft.koloboke.function.Predicate;

public class ImmutableLHashParallelKVByteByteMapGO
extends ImmutableLHashParallelKVByteByteMapSO {
    final void copy(ParallelKVByteByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVByteByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(byte key, byte value) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8) == value;
            }
            if (cur == free) {
                return false;
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (byte)(entry >>> 8) == value;
            } while (cur != free);
            return false;
        }
        return false;
    }

    @Override
    public Byte get(Object key) {
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue)) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(k) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == k) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return null;
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (byte)(entry >>> 8);
            } while (cur != free);
            return null;
        }
        return null;
    }

    public byte get(byte key) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (byte)(entry >>> 8);
            } while (cur != free);
            return this.defaultValue();
        }
        return this.defaultValue();
    }

    @Override
    public Byte getOrDefault(Object key, Byte defaultValue) {
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue)) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(k) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == k) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (byte)(entry >>> 8);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public byte getOrDefault(byte key, byte defaultValue) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (byte)(entry >>> 8);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Byte, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            action.accept((Object)key, (Object)((byte)(entry >>> 8)));
        }
    }

    public void forEach(ByteByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            action.accept(key, (byte)(entry >>> 8));
        }
    }

    public boolean forEachWhile(ByteBytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free || predicate.test(key, (byte)(entry >>> 8))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ByteByteCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonByteByteMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalByteByteMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free || m.containsEntry(key, (byte)(entry >>> 8))) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalByteByteMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            m.justPut(key, (byte)(entry >>> 8));
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Byte, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            hashCode += key ^ (byte)(entry >>> 8);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((byte)(entry >>> 8));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Byte put(Byte key, Byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte put(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte putIfAbsent(Byte key, Byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte putIfAbsent(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte compute(Byte key, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte compute(byte key, ByteByteToByteFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte computeIfAbsent(Byte key, Function<? super Byte, ? extends Byte> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte computeIfAbsent(byte key, ByteUnaryOperator mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte computeIfPresent(Byte key, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte computeIfPresent(byte key, ByteByteToByteFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte merge(Byte key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte merge(byte key, byte value, ByteBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte addValue(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    public byte addValue(byte key, byte addition, byte defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Byte, ? extends Byte> m) {
        CommonByteByteMapOps.putAll(this, m);
    }

    @Override
    public Byte replace(Byte key, Byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte replace(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Byte key, Byte oldValue, Byte newValue) {
        return this.replace((byte)key, (byte)oldValue, (byte)newValue);
    }

    @Override
    public boolean replace(byte key, byte oldValue, byte newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Byte, ? super Byte, ? extends Byte> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ByteByteToByteFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(byte key) {
        throw new UnsupportedOperationException();
    }

    public byte remove(byte key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Byte)key, (Byte)value);
    }

    public boolean remove(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ByteBytePredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ByteByteCursor {
        final char[] tab;
        final byte free;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedMapCursor() {
            byte free;
            this.tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue);
        }

        public void forEachForward(ByteByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(key, (byte)(entry >>> 8));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_VALUE_OFFSET + ((long)this.index << 1), value);
        }

        public boolean moveNext() {
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (byte)(entry >>> 8);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        final char[] tab;
        final byte free;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedValueCursor() {
            byte free;
            this.tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue);
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((byte)(entry >>> 8));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (byte)(entry >>> 8);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        final char[] tab;
        final byte free;
        int nextIndex;
        byte next;

        NoRemovedValueIterator() {
            this.tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            byte free = this.free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                if ((byte)entry == free) continue;
                this.next = (byte)(entry >>> 8);
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                char[] tab = this.tab;
                byte free = this.free;
                byte prev = this.next;
                while (--nextI >= 0) {
                    char entry = tab[nextI];
                    if ((byte)entry == free) continue;
                    this.next = (byte)(entry >>> 8);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((Object)((byte)(entry >>> 8)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((byte)(entry >>> 8));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Byte>> {
        final char[] tab;
        final byte free;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedEntryCursor() {
            byte free;
            this.tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Object)new ImmutableEntry(key, (byte)(entry >>> 8)));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Byte> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (byte)(entry >>> 8);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Byte>> {
        final char[] tab;
        final byte free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            byte free = this.free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                byte key = (byte)entry;
                if (key == free) continue;
                this.next = new ImmutableEntry(key, (byte)(entry >>> 8));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Object)new ImmutableEntry(key, (byte)(entry >>> 8)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Byte> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                char[] tab = this.tab;
                byte free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    char entry = tab[nextI];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, (byte)(entry >>> 8));
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableLHashParallelKVByteByteMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashParallelKVByteByteMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableLHashParallelKVByteByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return ImmutableLHashParallelKVByteByteMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((Object)((byte)(entry >>> 8)));
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((byte)(entry >>> 8));
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free || predicate.test((byte)(entry >>> 8))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free || c.contains((byte)(entry >>> 8))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                changed |= c.add((byte)(entry >>> 8));
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                changed |= s.removeByte((byte)(entry >>> 8));
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public ByteCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                result[resultIndex++] = (byte)(entry >>> 8);
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                a[resultIndex++] = (byte)(entry >>> 8);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                result[resultIndex++] = (byte)(entry >>> 8);
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                a[resultIndex++] = (byte)(entry >>> 8);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                sb.append(' ').append((byte)(entry >>> 8)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return ImmutableLHashParallelKVByteByteMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            ImmutableLHashParallelKVByteByteMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Byte> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(BytePredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ByteByteEntry {
        private byte key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(byte key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ByteByteEntry {
        private final byte key;
        private final byte value;

        ImmutableEntry(byte key, byte value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    abstract class ByteByteEntry
    extends AbstractEntry<Byte, Byte> {
        ByteByteEntry() {
        }

        abstract byte key();

        @Override
        public final Byte getKey() {
            return this.key();
        }

        abstract byte value();

        @Override
        public final Byte getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                byte k2 = (Byte)e2.getKey();
                byte v2 = (Byte)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Byte, Byte>>
    implements HashObjSet<Map.Entry<Byte, Byte>>,
    InternalObjCollectionOps<Map.Entry<Byte, Byte>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Byte, Byte>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashParallelKVByteByteMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableLHashParallelKVByteByteMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableLHashParallelKVByteByteMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashParallelKVByteByteMapGO.this.containsEntry((Byte)e.getKey(), (Byte)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, (byte)(entry >>> 8));
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, (byte)(entry >>> 8));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Byte, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Object)new ImmutableEntry(key, (byte)(entry >>> 8)));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Byte, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || predicate.test((Object)new ImmutableEntry(key, (byte)(entry >>> 8)))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Byte, Byte>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Byte, Byte>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || c.contains((Object)e.with(key, (byte)(entry >>> 8)))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (byte)(entry >>> 8)));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Byte, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, (byte)(entry >>> 8)));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableLHashParallelKVByteByteMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            byte free = ImmutableLHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableLHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((byte)(entry >>> 8));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashParallelKVByteByteMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                byte key = (Byte)e.getKey();
                byte value = (Byte)e.getValue();
                return ImmutableLHashParallelKVByteByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Byte, Byte>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableLHashParallelKVByteByteMapGO.this.clear();
        }
    }
}

