/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalShortCharMapOps;
import net.openhft.koloboke.collect.map.ShortCharMap;
import net.openhft.koloboke.function.ShortCharConsumer;
import net.openhft.koloboke.function.ShortCharPredicate;

public final class CommonShortCharMapOps {
    public static boolean containsAllEntries(final InternalShortCharMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ShortCharMap) {
            ShortCharMap m2 = (ShortCharMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalShortCharMapOps) {
                return ((InternalShortCharMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ShortCharPredicate(){

                public boolean test(short a, char b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Short)e.getKey(), ((Character)e.getValue()).charValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalShortCharMapOps map, Map<? extends Short, ? extends Character> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ShortCharMap) {
            if (another instanceof InternalShortCharMapOps) {
                ((InternalShortCharMapOps)another).reversePutAllTo(map);
            } else {
                ((ShortCharMap)another).forEach(new ShortCharConsumer(){

                    public void accept(short key, char value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Short, ? extends Character> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue().charValue());
            }
        }
    }

    private CommonShortCharMapOps() {
    }
}

