/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalObjObjMapOps;
import net.openhft.koloboke.collect.map.ObjObjMap;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiPredicate;

public final class CommonObjObjMapOps {
    public static boolean containsAllEntries(final InternalObjObjMapOps<?, ?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ObjObjMap) {
            ObjObjMap m2 = (ObjObjMap)another;
            if (m2.keyEquivalence().equals((Object)map.keyEquivalence()) && m2.valueEquivalence().equals((Object)map.valueEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalObjObjMapOps) {
                    return ((InternalObjObjMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new BiPredicate(){

                public boolean test(Object a, Object b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(e.getKey(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <K, V> void putAll(final InternalObjObjMapOps<K, V> map, Map<? extends K, ? extends V> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ObjObjMap) {
            if (another instanceof InternalObjObjMapOps) {
                ((InternalObjObjMapOps)another).reversePutAllTo(map);
            } else {
                ((ObjObjMap)another).forEach(new BiConsumer<K, V>(){

                    public void accept(K key, V value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<K, V> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonObjObjMapOps() {
    }
}

