/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalObjCharMapOps;
import net.openhft.koloboke.collect.map.ObjCharMap;
import net.openhft.koloboke.function.ObjCharConsumer;
import net.openhft.koloboke.function.ObjCharPredicate;

public final class CommonObjCharMapOps {
    public static boolean containsAllEntries(final InternalObjCharMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ObjCharMap) {
            ObjCharMap m2 = (ObjCharMap)another;
            if (m2.keyEquivalence().equals((Object)map.keyEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalObjCharMapOps) {
                    return ((InternalObjCharMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new ObjCharPredicate(){

                public boolean test(Object a, char b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(e.getKey(), ((Character)e.getValue()).charValue())) continue;
            return false;
        }
        return true;
    }

    public static <K> void putAll(final InternalObjCharMapOps<K> map, Map<? extends K, ? extends Character> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ObjCharMap) {
            if (another instanceof InternalObjCharMapOps) {
                ((InternalObjCharMapOps)another).reversePutAllTo(map);
            } else {
                ((ObjCharMap)another).forEach(new ObjCharConsumer<K>(){

                    public void accept(K key, char value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<K, Character> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue().charValue());
            }
        }
    }

    private CommonObjCharMapOps() {
    }
}

