/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalIntFloatMapOps;
import net.openhft.koloboke.collect.map.IntFloatMap;
import net.openhft.koloboke.function.IntFloatConsumer;
import net.openhft.koloboke.function.IntFloatPredicate;

public final class CommonIntFloatMapOps {
    public static boolean containsAllEntries(final InternalIntFloatMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof IntFloatMap) {
            IntFloatMap m2 = (IntFloatMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalIntFloatMapOps) {
                return ((InternalIntFloatMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new IntFloatPredicate(){

                public boolean test(int a, float b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((int)((Integer)e.getKey()), ((Float)e.getValue()).floatValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalIntFloatMapOps map, Map<? extends Integer, ? extends Float> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof IntFloatMap) {
            if (another instanceof InternalIntFloatMapOps) {
                ((InternalIntFloatMapOps)another).reversePutAllTo(map);
            } else {
                ((IntFloatMap)another).forEach(new IntFloatConsumer(){

                    public void accept(int key, float value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Integer, ? extends Float> e : another.entrySet()) {
                map.justPut((int)e.getKey(), e.getValue().floatValue());
            }
        }
    }

    private CommonIntFloatMapOps() {
    }
}

