/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalIntCharMapOps;
import net.openhft.koloboke.collect.map.IntCharMap;
import net.openhft.koloboke.function.IntCharConsumer;
import net.openhft.koloboke.function.IntCharPredicate;

public final class CommonIntCharMapOps {
    public static boolean containsAllEntries(final InternalIntCharMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof IntCharMap) {
            IntCharMap m2 = (IntCharMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalIntCharMapOps) {
                return ((InternalIntCharMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new IntCharPredicate(){

                public boolean test(int a, char b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Integer)e.getKey(), ((Character)e.getValue()).charValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalIntCharMapOps map, Map<? extends Integer, ? extends Character> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof IntCharMap) {
            if (another instanceof InternalIntCharMapOps) {
                ((InternalIntCharMapOps)another).reversePutAllTo(map);
            } else {
                ((IntCharMap)another).forEach(new IntCharConsumer(){

                    public void accept(int key, char value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Integer, ? extends Character> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue().charValue());
            }
        }
    }

    private CommonIntCharMapOps() {
    }
}

