/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalFloatShortMapOps;
import net.openhft.koloboke.collect.map.FloatShortMap;
import net.openhft.koloboke.function.FloatShortConsumer;
import net.openhft.koloboke.function.FloatShortPredicate;

public final class CommonFloatShortMapOps {
    public static boolean containsAllEntries(final InternalFloatShortMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof FloatShortMap) {
            FloatShortMap m2 = (FloatShortMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalFloatShortMapOps) {
                return ((InternalFloatShortMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new FloatShortPredicate(){

                public boolean test(float a, short b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Float)e.getKey()).floatValue(), (short)((Short)e.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalFloatShortMapOps map, Map<? extends Float, ? extends Short> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof FloatShortMap) {
            if (another instanceof InternalFloatShortMapOps) {
                ((InternalFloatShortMapOps)another).reversePutAllTo(map);
            } else {
                ((FloatShortMap)another).forEach(new FloatShortConsumer(){

                    public void accept(float key, short value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Float, ? extends Short> e : another.entrySet()) {
                map.justPut(e.getKey().floatValue(), (short)e.getValue());
            }
        }
    }

    private CommonFloatShortMapOps() {
    }
}

