/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalFloatDoubleMapOps;
import net.openhft.koloboke.collect.map.FloatDoubleMap;
import net.openhft.koloboke.function.FloatDoubleConsumer;
import net.openhft.koloboke.function.FloatDoublePredicate;

public final class CommonFloatDoubleMapOps {
    public static boolean containsAllEntries(final InternalFloatDoubleMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof FloatDoubleMap) {
            FloatDoubleMap m2 = (FloatDoubleMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalFloatDoubleMapOps) {
                return ((InternalFloatDoubleMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new FloatDoublePredicate(){

                public boolean test(float a, double b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Float)e.getKey()).floatValue(), (Double)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalFloatDoubleMapOps map, Map<? extends Float, ? extends Double> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof FloatDoubleMap) {
            if (another instanceof InternalFloatDoubleMapOps) {
                ((InternalFloatDoubleMapOps)another).reversePutAllTo(map);
            } else {
                ((FloatDoubleMap)another).forEach(new FloatDoubleConsumer(){

                    public void accept(float key, double value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Float, ? extends Double> e : another.entrySet()) {
                map.justPut(e.getKey().floatValue(), e.getValue());
            }
        }
    }

    private CommonFloatDoubleMapOps() {
    }
}

