/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalByteByteMapOps;
import net.openhft.koloboke.collect.map.ByteByteMap;
import net.openhft.koloboke.function.ByteByteConsumer;
import net.openhft.koloboke.function.ByteBytePredicate;

public final class CommonByteByteMapOps {
    public static boolean containsAllEntries(final InternalByteByteMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ByteByteMap) {
            ByteByteMap m2 = (ByteByteMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalByteByteMapOps) {
                return ((InternalByteByteMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ByteBytePredicate(){

                public boolean test(byte a, byte b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Byte)e.getKey(), (Byte)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalByteByteMapOps map, Map<? extends Byte, ? extends Byte> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ByteByteMap) {
            if (another instanceof InternalByteByteMapOps) {
                ((InternalByteByteMapOps)another).reversePutAllTo(map);
            } else {
                ((ByteByteMap)another).forEach(new ByteByteConsumer(){

                    public void accept(byte key, byte value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Byte, ? extends Byte> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonByteByteMapOps() {
    }
}

