/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.predicate.PredicateBuilder;
import io.undertow.protocols.http2.HpackException;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="UT")
public interface UndertowMessages {
    public static final UndertowMessages MESSAGES = (UndertowMessages)Messages.getBundle(UndertowMessages.class);

    @Message(id=1, value="Maximum concurrent requests must be larger than zero.")
    public IllegalArgumentException maximumConcurrentRequestsMustBeLargerThanZero();

    @Message(id=2, value="The response has already been started")
    public IllegalStateException responseAlreadyStarted();

    @Message(id=4, value="getResponseChannel() has already been called")
    public IllegalStateException responseChannelAlreadyProvided();

    @Message(id=5, value="getRequestChannel() has already been called")
    public IllegalStateException requestChannelAlreadyProvided();

    @Message(id=8, value="Handler cannot be null")
    public IllegalArgumentException handlerCannotBeNull();

    @Message(id=9, value="Path must be specified")
    public IllegalArgumentException pathMustBeSpecified();

    @Message(id=10, value="Session is invalid %s")
    public IllegalStateException sessionIsInvalid(String var1);

    @Message(id=11, value="Session manager must not be null")
    public IllegalStateException sessionManagerMustNotBeNull();

    @Message(id=12, value="Session manager was not attached to the request. Make sure that the SessionAttachmentHandler is installed in the handler chain")
    public IllegalStateException sessionManagerNotFound();

    @Message(id=13, value="Argument %s cannot be null")
    public IllegalArgumentException argumentCannotBeNull(String var1);

    @Message(id=14, value="close() called with data still to be flushed. Please call shutdownWrites() and then call flush() until it returns true before calling close()")
    public IOException closeCalledWithDataStillToBeFlushed();

    @Message(id=16, value="Could not add cookie as cookie handler was not present in the handler chain")
    public IllegalStateException cookieHandlerNotPresent();

    @Message(id=17, value="Form value is a file, use getFile() instead")
    public IllegalStateException formValueIsAFile();

    @Message(id=18, value="Form value is a String, use getValue() instead")
    public IllegalStateException formValueIsAString();

    @Message(id=19, value="Connection from %s terminated as request entity was larger than %s")
    public IOException requestEntityWasTooLarge(SocketAddress var1, long var2);

    @Message(id=20, value="Connection terminated as request was larger than %s")
    public IOException requestEntityWasTooLarge(long var1);

    @Message(id=21, value="Session already invalidated")
    public IllegalStateException sessionAlreadyInvalidated();

    @Message(id=22, value="The specified hash algorithm '%s' can not be found.")
    public IllegalArgumentException hashAlgorithmNotFound(String var1);

    @Message(id=23, value="An invalid Base64 token has been received.")
    public IllegalArgumentException invalidBase64Token(@Cause IOException var1);

    @Message(id=24, value="An invalidly formatted nonce has been received.")
    public IllegalArgumentException invalidNonceReceived();

    @Message(id=25, value="Unexpected token '%s' within header.")
    public IllegalArgumentException unexpectedTokenInHeader(String var1);

    @Message(id=26, value="Invalid header received.")
    public IllegalArgumentException invalidHeader();

    @Message(id=27, value="Could not find session cookie config in the request")
    public IllegalStateException couldNotFindSessionCookieConfig();

    @Message(id=28, value="Session %s already exists")
    public IllegalStateException sessionAlreadyExists(String var1);

    @Message(id=29, value="Channel was closed mid chunk, if you have attempted to write chunked data you cannot shutdown the channel until after it has all been written.")
    public IOException chunkedChannelClosedMidChunk();

    @Message(id=30, value="User %s successfully authenticated.")
    public String userAuthenticated(String var1);

    @Message(id=31, value="User %s has logged out.")
    public String userLoggedOut(String var1);

    @Message(id=33, value="Authentication type %s cannot be combined with %s")
    public IllegalStateException authTypeCannotBeCombined(String var1, String var2);

    @Message(id=34, value="Stream is closed")
    public IOException streamIsClosed();

    @Message(id=35, value="Cannot get stream as startBlocking has not been invoked")
    public IllegalStateException startBlockingHasNotBeenCalled();

    @Message(id=36, value="Connection terminated parsing multipart data")
    public IOException connectionTerminatedReadingMultiPartData();

    @Message(id=37, value="Failed to parse path in HTTP request")
    public RuntimeException failedToParsePath();

    @Message(id=38, value="Authentication failed, requested user name '%s'")
    public String authenticationFailed(String var1);

    @Message(id=39, value="To many query parameters, cannot have more than %s query parameters")
    public RuntimeException tooManyQueryParameters(int var1);

    @Message(id=40, value="To many headers, cannot have more than %s header")
    public RuntimeException tooManyHeaders(int var1);

    @Message(id=41, value="Channel is closed")
    public ClosedChannelException channelIsClosed();

    @Message(id=42, value="Could not decode trailers in HTTP request")
    public IOException couldNotDecodeTrailers();

    @Message(id=43, value="Data is already being sent. You must wait for the completion callback to be be invoked before calling send() again")
    public IllegalStateException dataAlreadyQueued();

    @Message(id=44, value="More than one predicate with name %s. Builder class %s and %s")
    public IllegalStateException moreThanOnePredicateWithName(String var1, Class<? extends PredicateBuilder> var2, Class<? extends PredicateBuilder> var3);

    @Message(id=45, value="Error parsing predicated handler string %s:%n%s")
    public IllegalArgumentException errorParsingPredicateString(String var1, String var2);

    @Message(id=46, value="The number of cookies sent exceeded the maximum of %s")
    public IllegalStateException tooManyCookies(int var1);

    @Message(id=47, value="The number of parameters exceeded the maximum of %s")
    public IllegalStateException tooManyParameters(int var1);

    @Message(id=48, value="No request is currently active")
    public IllegalStateException noRequestActive();

    @Message(id=50, value="AuthenticationMechanism Outcome is null")
    public IllegalStateException authMechanismOutcomeNull();

    @Message(id=51, value="Not a valid IP pattern %s")
    public IllegalArgumentException notAValidIpPattern(String var1);

    @Message(id=52, value="Session data requested when non session based authentication in use")
    public IllegalStateException noSessionData();

    @Message(id=53, value="Listener %s already registered")
    public IllegalArgumentException listenerAlreadyRegistered(String var1);

    @Message(id=54, value="The maximum size %s for an individual file in a multipart request was exceeded")
    public IOException maxFileSizeExceeded(long var1);

    @Message(id=55, value="Could not set attribute %s to %s as it is read only")
    public String couldNotSetAttribute(String var1, String var2);

    @Message(id=56, value="Could not parse URI template %s, exception at char %s")
    public RuntimeException couldNotParseUriTemplate(String var1, int var2);

    @Message(id=57, value="Mismatched braces in attribute string %s")
    public RuntimeException mismatchedBraces(String var1);

    @Message(id=58, value="More than one handler with name %s. Builder class %s and %s")
    public IllegalStateException moreThanOneHandlerWithName(String var1, Class<? extends HandlerBuilder> var2, Class<? extends HandlerBuilder> var3);

    @Message(id=59, value="Invalid syntax %s")
    public IllegalArgumentException invalidSyntax(String var1);

    @Message(id=60, value="Error parsing handler string %s:%n%s")
    public IllegalArgumentException errorParsingHandlerString(String var1, String var2);

    @Message(id=61, value="Out of band responses only allowed for 100-continue requests")
    public IllegalArgumentException outOfBandResponseOnlyAllowedFor100Continue();

    @Message(id=62, value="AJP does not support HTTP upgrade")
    public IllegalStateException ajpDoesNotSupportHTTPUpgrade();

    @Message(id=63, value="File system watcher already started")
    public IllegalStateException fileSystemWatcherAlreadyStarted();

    @Message(id=64, value="File system watcher not started")
    public IllegalStateException fileSystemWatcherNotStarted();

    @Message(id=65, value="SSL must be specified to connect to a https URL")
    public IOException sslWasNull();

    @Message(id=66, value="Incorrect magic number %s for AJP packet header")
    public IOException wrongMagicNumber(int var1);

    @Message(id=67, value="No client cert was provided")
    public SSLPeerUnverifiedException peerUnverified();

    @Message(id=68, value="Servlet path match failed")
    public IllegalArgumentException servletPathMatchFailed();

    @Message(id=69, value="Could not parse set cookie header %s")
    public IllegalArgumentException couldNotParseCookie(String var1);

    @Message(id=70, value="method can only be called by IO thread")
    public IllegalStateException canOnlyBeCalledByIoThread();

    @Message(id=71, value="Cannot add path template %s, matcher already contains an equivalent pattern %s")
    public IllegalStateException matcherAlreadyContainsTemplate(String var1, String var2);

    @Message(id=72, value="Failed to decode url %s to charset %s")
    public IllegalArgumentException failedToDecodeURL(String var1, String var2, @Cause Exception var3);

    @Message(id=73, value="Resource change listeners are not supported")
    public IllegalArgumentException resourceChangeListenerNotSupported();

    @Message(id=74, value="Could not renegotiate SSL connection to require client certificate, as client had sent more data")
    public IllegalStateException couldNotRenegotiate();

    @Message(id=75, value="Object was freed")
    public IllegalStateException objectWasFreed();

    @Message(id=76, value="Handler not shutdown")
    public IllegalStateException handlerNotShutdown();

    @Message(id=77, value="The underlying transport does not support HTTP upgrade")
    public IllegalStateException upgradeNotSupported();

    @Message(id=78, value="Renegotiation not supported")
    public IOException renegotiationNotSupported();

    @Message(id=79, value="Not a valid user agent pattern %s")
    public IllegalArgumentException notAValidUserAgentPattern(String var1);

    @Message(id=80, value="Not a valid regular expression pattern %s")
    public IllegalArgumentException notAValidRegularExpressionPattern(String var1);

    @Message(id=81, value="Bad request")
    public RuntimeException badRequest();

    @Message(id=82, value="Host %s already registered")
    public RuntimeException hostAlreadyRegistered(Object var1);

    @Message(id=83, value="Host %s has not been registered")
    public RuntimeException hostHasNotBeenRegistered(Object var1);

    @Message(id=84, value="Attempted to write additional data after the last chunk")
    public IOException extraDataWrittenAfterChunkEnd();

    @Message(id=85, value="Could not generate unique session id")
    public RuntimeException couldNotGenerateUniqueSessionId();

    @Message(id=86, value="SPDY needs to be provided with a heap buffer pool, for use in compressing and decompressing headers.")
    public IllegalArgumentException mustProvideHeapBuffer();

    @Message(id=87, value="Unexpected SPDY frame type %s")
    public IOException unexpectedFrameType(int var1);

    @Message(id=88, value="SPDY control frames cannot have body content")
    public IOException controlFrameCannotHaveBodyContent();

    @Message(id=90, value="No ALPN implementation available (tried Jetty ALPN and JDK9)")
    public IOException alpnNotAvailable();

    @Message(id=91, value="Buffer has already been freed")
    public IllegalStateException bufferAlreadyFreed();

    @Message(id=92, value="A SPDY header was too large to fit in a response buffer, if you want to support larger headers please increase the buffer size")
    public IllegalStateException headersTooLargeToFitInHeapBuffer();

    @Message(id=94, value="Blocking await method called from IO thread. Blocking IO must be dispatched to a worker thread or deadlocks will result.")
    public IOException awaitCalledFromIoThread();

    @Message(id=95, value="Recursive call to flushSenders()")
    public RuntimeException recursiveCallToFlushingSenders();

    @Message(id=96, value="More data was written to the channel than specified in the content-length")
    public IllegalStateException fixedLengthOverflow();

    @Message(id=97, value="AJP request already in progress")
    public IllegalStateException ajpRequestAlreadyInProgress();

    @Message(id=98, value="HTTP ping data must be 8 bytes in length")
    public String httpPingDataMustBeLength8();

    @Message(id=99, value="Received a ping of size other than 8")
    public String invalidPingSize();

    @Message(id=100, value="stream id must be zero for frame type %s")
    public String streamIdMustBeZeroForFrameType(int var1);

    @Message(id=101, value="stream id must not be zero for frame type %s")
    public String streamIdMustNotBeZeroForFrameType(int var1);

    @Message(id=102, value="RST_STREAM received for idle stream")
    public String rstStreamReceivedForIdleStream();

    @Message(id=103, value="Http2 stream was reset")
    public IOException http2StreamWasReset();

    @Message(id=104, value="Incorrect HTTP2 preface")
    public IOException incorrectHttp2Preface();

    @Message(id=105, value="HTTP2 frame to large")
    public IOException http2FrameTooLarge();

    @Message(id=106, value="HTTP2 continuation frame received without a corresponding headers or push promise frame")
    public IOException http2ContinuationFrameNotExpected();

    @Message(id=107, value="Huffman encoded value in HPACK headers did not end with EOS padding")
    public HpackException huffmanEncodedHpackValueDidNotEndWithEOS();

    @Message(id=108, value="HPACK variable length integer encoded over too many octects, max is %s")
    public HpackException integerEncodedOverTooManyOctets(int var1);

    @Message(id=109, value="Zero is not a valid header table index")
    public HpackException zeroNotValidHeaderTableIndex();

    @Message(id=110, value="Cannot send 100-Continue, getResponseChannel() has already been called")
    public IOException cannotSendContinueResponse();

    @Message(id=111, value="Parser did not make progress")
    public IOException parserDidNotMakeProgress();

    @Message(id=112, value="Only client side can call createStream, if you wish to send a PUSH_PROMISE frame use createPushPromiseStream instead")
    public IOException headersStreamCanOnlyBeCreatedByClient();

    @Message(id=113, value="Only the server side can send a push promise stream")
    public IOException pushPromiseCanOnlyBeCreatedByServer();

    @Message(id=114, value="Invalid IP access control rule %s. Format is: [ip-match] allow|deny")
    public IllegalArgumentException invalidAclRule(String var1);

    @Message(id=115, value="Server received PUSH_PROMISE frame from client")
    public IOException serverReceivedPushPromise();

    @Message(id=116, value="CONNECT not supported by this connector")
    public IllegalStateException connectNotSupported();

    @Message(id=117, value="Request was not a CONNECT request")
    public IllegalStateException notAConnectRequest();

    @Message(id=118, value="Cannot reset buffer, response has already been commited")
    public IllegalStateException cannotResetBuffer();

    @Message(id=119, value="HTTP2 via prior knowledge failed")
    public IOException http2PriRequestFailed();

    @Message(id=120, value="Out of band responses are not allowed for this connector")
    public IllegalStateException outOfBandResponseNotSupported();

    @Message(id=121, value="Session was rejected as the maximum number of sessions (%s) has been hit")
    public IllegalStateException tooManySessions(int var1);

    @Message(id=122, value="CONNECT attempt failed as target proxy returned %s")
    public IOException proxyConnectionFailed(int var1);

    @Message(id=123, value="MCMP message %s rejected due to suspicious characters")
    public RuntimeException mcmpMessageRejectedDueToSuspiciousCharacters(String var1);

    @Message(id=124, value="renegotiation timed out")
    public IllegalStateException rengotiationTimedOut();

    @Message(id=125, value="Request body already read")
    public IllegalStateException requestBodyAlreadyRead();

    @Message(id=126, value="Attempted to do blocking IO from the IO thread. This is prohibited as it may result in deadlocks")
    public IllegalStateException blockingIoFromIOThread();

    @Message(id=127, value="Response has already been sent")
    public IllegalStateException responseComplete();

    @Message(id=128, value="Remote peer closed connection before all data could be read")
    public IOException couldNotReadContentLengthData();

    @Message(id=129, value="Failed to send after being safe to send")
    public IllegalStateException failedToSendAfterBeingSafe();

    @Message(id=130, value="HTTP reason phrase was too large for the buffer. Either provide a smaller message or a bigger buffer. Phrase: %s")
    public IllegalStateException reasonPhraseToLargeForBuffer(String var1);

    @Message(id=131, value="Buffer pool is closed")
    public IllegalStateException poolIsClosed();

    @Message(id=132, value="HPACK decode failed")
    public HpackException hpackFailed();

    @Message(id=133, value="Request did not contain an Upgrade header, upgrade is not permitted")
    public IllegalStateException notAnUpgradeRequest();

    @Message(id=134, value="Authentication mechanism %s requires property %s to be set")
    public IllegalStateException authenticationPropertyNotSet(String var1, String var2);

    @Message(id=135, value="renegotiation failed")
    public IllegalStateException rengotiationFailed();

    @Message(id=136, value="User agent charset string must have an even number of items, in the form pattern,charset,pattern,charset,... Instead got: %s")
    public IllegalArgumentException userAgentCharsetMustHaveEvenNumberOfItems(String var1);

    @Message(id=137, value="Could not find the datasource called %s")
    public IllegalArgumentException datasourceNotFound(String var1);

    @Message(id=138, value="Server not started")
    public IllegalStateException serverNotStarted();

    @Message(id=139, value="Exchange already complete")
    public IllegalStateException exchangeAlreadyComplete();

    @Message(id=140, value="Initial SSL/TLS data is not a handshake record")
    public SSLHandshakeException notHandshakeRecord();

    @Message(id=141, value="Initial SSL/TLS handshake record is invalid")
    public SSLHandshakeException invalidHandshakeRecord();

    @Message(id=142, value="Initial SSL/TLS handshake spans multiple records")
    public SSLHandshakeException multiRecordSSLHandshake();

    @Message(id=143, value="Expected \"client hello\" record")
    public SSLHandshakeException expectedClientHello();

    @Message(id=144, value="Expected server hello")
    public SSLHandshakeException expectedServerHello();

    @Message(id=145, value="Too many redirects")
    public IOException tooManyRedirects(@Cause IOException var1);

    @Message(id=146, value="HttpServerExchange cannot have both async IO resumed and dispatch() called in the same cycle")
    public IllegalStateException resumedAndDispatched();

    @Message(id=147, value="No host header in a HTTP/1.1 request")
    public IOException noHostInHttp11Request();

    @Message(id=148, value="Invalid HPack encoding. First byte: %s")
    public HpackException invalidHpackEncoding(byte var1);

    @Message(id=149, value="HttpString is not allowed to contain newlines. value: %s")
    public IllegalArgumentException newlineNotSupportedInHttpString(String var1);

    @Message(id=150, value="Pseudo header %s received after receiving normal headers. Pseudo headers must be the first headers in a HTTP/2 header block.")
    public HpackException pseudoHeaderInWrongOrder(HttpString var1);

    @Message(id=151, value="Expected to receive a continuation frame")
    public String expectedContinuationFrame();

    @Message(id=152, value="Incorrect frame size")
    public String incorrectFrameSize();

    @Message(id=153, value="Stream id not registered")
    public IllegalStateException streamNotRegistered();
}

