/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.subscription;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.subscription.CancellableSubscriber;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;

public class Subscribers {
    private static final Consumer<? super Throwable> NO_ON_FAILURE = failure -> new Exception("Missing onError method in the subscriber", (Throwable)failure).printStackTrace();

    public static <T> CancellableSubscriber<T> cancelled() {
        return new CancellationSubscriber();
    }

    public static <T> CancellableSubscriber<T> from(Consumer<? super T> onItem) {
        return new CallbackBasedSubscriber<T>(onItem, NO_ON_FAILURE, null, null);
    }

    public static <T> CancellableSubscriber<T> from(Consumer<? super T> onItem, Consumer<? super Throwable> onFailure) {
        return new CallbackBasedSubscriber<T>(onItem, onFailure, null, null);
    }

    public static <T> CancellableSubscriber<T> from(Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onCompletion) {
        return new CallbackBasedSubscriber<T>(onItem, onFailure, onCompletion, null);
    }

    public static <T> CancellableSubscriber<T> from(Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onCompletion, Consumer<? super Subscription> onSubscription) {
        return new CallbackBasedSubscriber<T>(onItem, onFailure, onCompletion, onSubscription);
    }

    private static class CallbackBasedSubscriber<T>
    implements CancellableSubscriber<T>,
    Subscription {
        private final AtomicReference<Subscription> subscription = new AtomicReference();
        private final Consumer<? super T> onItem;
        private final Consumer<? super Throwable> onFailure;
        private final Runnable onCompletion;
        private final Consumer<? super Subscription> onSubscription;

        public CallbackBasedSubscriber(Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onCompletion, Consumer<? super Subscription> onSubscription) {
            this.onItem = ParameterValidation.nonNull(onItem, "onItem");
            this.onFailure = onFailure;
            this.onCompletion = onCompletion;
            this.onSubscription = ParameterValidation.nonNull(onSubscription, "onSubscription");
        }

        public void onSubscribe(Subscription s) {
            if (this.subscription.compareAndSet(null, s)) {
                try {
                    this.onSubscription.accept(this);
                }
                catch (Throwable ex) {
                    s.cancel();
                    this.onError(ex);
                }
            } else {
                s.cancel();
            }
        }

        @Override
        public void onItem(T item) {
            if (this.subscription.get() != Subscriptions.CANCELLED) {
                try {
                    this.onItem.accept(item);
                }
                catch (Throwable e) {
                    this.subscription.getAndSet(Subscriptions.CANCELLED).cancel();
                    this.onError(e);
                }
            }
        }

        @Override
        public void onFailure(Throwable t) {
            if (this.subscription.getAndSet(Subscriptions.CANCELLED) != Subscriptions.CANCELLED && this.onFailure != null) {
                this.onFailure.accept(t);
            }
        }

        @Override
        public void onCompletion() {
            if (this.subscription.getAndSet(Subscriptions.CANCELLED) != Subscriptions.CANCELLED && this.onCompletion != null) {
                this.onCompletion.run();
            }
        }

        public void request(long n) {
            this.subscription.get().request(n);
        }

        @Override
        public void cancel() {
            Subscription prev = this.subscription.getAndSet(Subscriptions.CANCELLED);
            if (prev != null && prev != Subscriptions.CANCELLED) {
                prev.cancel();
            }
        }
    }

    private static class CancellationSubscriber<T>
    implements CancellableSubscriber<T> {
        private CancellationSubscriber() {
        }

        public void onSubscribe(Subscription s) {
            s.cancel();
        }

        @Override
        public void onItem(T t) {
        }

        @Override
        public void onFailure(Throwable t) {
        }

        @Override
        public void onCompletion() {
        }

        @Override
        public void cancel() {
        }
    }
}

