/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.api;

import io.scalecube.services.api.ErrorData;
import io.scalecube.services.api.Qualifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public final class ServiceMessage {
    public static final String DEFAULT_DATA_FORMAT = "application/json";
    public static final String HEADER_QUALIFIER = "q";
    public static final String HEADER_DATA_TYPE = "type";
    public static final String HEADER_DATA_FORMAT = "dataFormat";
    public static final String HEADER_ERROR_TYPE = "errorType";
    public static final int NULL_ERROR_TYPE = -1;
    private final Map<String, String> headers;
    private Object data;

    ServiceMessage() {
        this.headers = new HashMap<String, String>(2);
    }

    private ServiceMessage(Builder builder) {
        this.data = builder.data;
        this.headers = Collections.unmodifiableMap(new HashMap(builder.headers));
    }

    public static Builder from(ServiceMessage message) {
        return ServiceMessage.builder().data(message.data()).headers(message.headers());
    }

    public static ServiceMessage error(String qualifier, int errorType, int errorCode, String errorMessage) {
        return ServiceMessage.builder().qualifier(qualifier).header(HEADER_ERROR_TYPE, String.valueOf(errorType)).data(new ErrorData(errorCode, errorMessage)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public String header(String name) {
        Objects.requireNonNull(name, "header name");
        return this.headers.get(name);
    }

    public String qualifier() {
        return this.header(HEADER_QUALIFIER);
    }

    public String dataFormat() {
        return this.header(HEADER_DATA_FORMAT);
    }

    public String dataFormatOrDefault() {
        return Optional.ofNullable(this.dataFormat()).orElse(DEFAULT_DATA_FORMAT);
    }

    public <T> T data() {
        return (T)this.data;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean hasData(Class<?> dataClass) {
        if (dataClass == null) {
            return false;
        }
        if (dataClass.isPrimitive()) {
            return this.hasData();
        }
        return dataClass.isInstance(this.data);
    }

    public boolean isError() {
        return this.headers.containsKey(HEADER_ERROR_TYPE);
    }

    public int errorType() {
        String errorType = this.headers.get(HEADER_ERROR_TYPE);
        if (errorType == null) {
            return -1;
        }
        try {
            return Integer.parseInt(errorType);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Error type must be a number");
        }
    }

    public String toString() {
        return new StringJoiner(", ", ServiceMessage.class.getSimpleName() + "[", "]").add("headers(" + this.headers.size() + ")").add("data=" + (this.data != null ? this.data.getClass().getName() : null)).toString();
    }

    public static class Builder {
        private final Map<String, String> headers = new HashMap<String, String>(2);
        private Object data;

        private Builder() {
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        @Deprecated
        public Builder dataType(Class<?> dataType) {
            Objects.requireNonNull(dataType, "dataType");
            this.headers.put(ServiceMessage.HEADER_DATA_TYPE, dataType.getName());
            return this;
        }

        public Builder dataFormat(String dataFormat) {
            this.headers.put(ServiceMessage.HEADER_DATA_FORMAT, dataFormat);
            return this;
        }

        public Builder dataFormatIfAbsent(String dataFormat) {
            if (dataFormat == null) {
                return this;
            }
            this.headers.putIfAbsent(ServiceMessage.HEADER_DATA_FORMAT, dataFormat);
            return this;
        }

        private Map<String, String> headers() {
            return this.headers;
        }

        public Builder headers(Map<String, String> headers) {
            Objects.requireNonNull(headers, "headers").forEach(this::header);
            return this;
        }

        public Builder header(String key, String value) {
            Objects.requireNonNull(key, "header name");
            Objects.requireNonNull(value, "header value");
            this.headers.put(key, value);
            return this;
        }

        public Builder header(String key, Object value) {
            Objects.requireNonNull(key, "header name");
            Objects.requireNonNull(value, "header value");
            this.headers.put(key, value.toString());
            return this;
        }

        public Builder qualifier(String qualifier) {
            return this.header(ServiceMessage.HEADER_QUALIFIER, Objects.requireNonNull(qualifier, "qualifier"));
        }

        public Builder qualifier(String namespace, String action) {
            return this.qualifier(Qualifier.asString(Objects.requireNonNull(namespace, "namespace"), Objects.requireNonNull(action, "action")));
        }

        public ServiceMessage build() {
            return new ServiceMessage(this);
        }
    }
}

