/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.ConnectionOptions;
import io.r2dbc.mssql.MssqlResult;
import io.r2dbc.mssql.SimpleMssqlStatement;
import io.r2dbc.mssql.client.Client;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.Batch;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Flux;

public final class MssqlBatch
implements Batch {
    private final Client client;
    private final ConnectionOptions connectionOptions;
    private final List<String> statements = new ArrayList<String>();

    MssqlBatch(Client client, ConnectionOptions connectionOptions) {
        this.client = Assert.requireNonNull(client, "Client must not be null");
        this.connectionOptions = Assert.requireNonNull(connectionOptions, "ConnectionOptions must not be null");
    }

    public MssqlBatch add(String sql) {
        Assert.requireNonNull(sql, "SQL must not be null");
        this.statements.add(sql);
        return this;
    }

    public Flux<MssqlResult> execute() {
        return new SimpleMssqlStatement(this.client, this.connectionOptions, String.join((CharSequence)"; ", this.statements)).execute();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [client=").append(this.client);
        sb.append(", connectionOptions=").append(this.connectionOptions);
        sb.append(", statements=").append(this.statements);
        sb.append(']');
        return sb.toString();
    }
}

