/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.IndefinitePreparedStatementCache;
import io.r2dbc.mssql.PreparedStatementCache;
import io.r2dbc.mssql.codec.Codecs;
import io.r2dbc.mssql.codec.DefaultCodecs;
import java.time.Duration;
import java.util.function.Predicate;
import reactor.util.annotation.Nullable;

class ConnectionOptions {
    private final Predicate<String> preferCursoredExecution;
    private final Codecs codecs;
    private final PreparedStatementCache preparedStatementCache;
    private final boolean sendStringParametersAsUnicode;
    private volatile Duration statementTimeout = Duration.ZERO;

    ConnectionOptions() {
        this(sql -> false, new DefaultCodecs(), new IndefinitePreparedStatementCache(), true);
    }

    ConnectionOptions(Predicate<String> preferCursoredExecution, Codecs codecs, PreparedStatementCache preparedStatementCache, boolean sendStringParametersAsUnicode) {
        this.preferCursoredExecution = preferCursoredExecution;
        this.codecs = codecs;
        this.preparedStatementCache = preparedStatementCache;
        this.sendStringParametersAsUnicode = sendStringParametersAsUnicode;
    }

    public Codecs getCodecs() {
        return this.codecs;
    }

    public PreparedStatementCache getPreparedStatementCache() {
        return this.preparedStatementCache;
    }

    public boolean prefersCursors(String sql) {
        return this.preferCursoredExecution.test(sql);
    }

    public boolean isSendStringParametersAsUnicode() {
        return this.sendStringParametersAsUnicode;
    }

    public Duration getStatementTimeout() {
        return this.statementTimeout;
    }

    public void setStatementTimeout(@Nullable Duration statementTimeout) {
        this.statementTimeout = statementTimeout;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [preferCursoredExecution=").append(this.preferCursoredExecution);
        sb.append(", codecs=").append(this.codecs);
        sb.append(", preparedStatementCache=").append(this.preparedStatementCache);
        sb.append(", sendStringParametersAsUnicode=").append(this.sendStringParametersAsUnicode);
        sb.append(", statementTimeout=").append(this.statementTimeout);
        sb.append(']');
        return sb.toString();
    }
}

