/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.PropertiesConfigSource;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class ApplicationPropertiesConfigSourceLoader
extends AbstractLocationConfigSourceLoader {
    protected String[] getFileExtensions() {
        return new String[]{"properties"};
    }

    protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
        return new PropertiesConfigSource(url, ordinal);
    }

    public static class InFileSystem
    extends ApplicationPropertiesConfigSourceLoader
    implements ConfigSourceProvider {
        @Override
        protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
            return super.loadConfigSource(url, 260);
        }

        public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
            return this.loadConfigSources(Paths.get(System.getProperty("user.dir"), "config", "application.properties").toUri().toString(), classLoader);
        }

        protected List<ConfigSource> tryClassPath(URI uri, ClassLoader classLoader) {
            return new ArrayList<ConfigSource>();
        }
    }

    public static class InClassPath
    extends ApplicationPropertiesConfigSourceLoader
    implements ConfigSourceProvider {
        @Override
        protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
            return super.loadConfigSource(url, 250);
        }

        public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
            return this.loadConfigSources("application.properties", classLoader);
        }

        protected List<ConfigSource> tryFileSystem(URI uri) {
            return new ArrayList<ConfigSource>();
        }
    }
}

