/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty;

import io.netty.bootstrap.AbstractBootstrap;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public class ChannelBindException
extends RuntimeException {
    final String localHost;
    final int localPort;

    public static ChannelBindException fail(AbstractBootstrap<?, ?> bootstrap, @Nullable Throwable cause) {
        Objects.requireNonNull(bootstrap, "bootstrap");
        if (cause instanceof BindException) {
            cause = null;
        }
        if (!(bootstrap.config().localAddress() instanceof InetSocketAddress)) {
            return new ChannelBindException(bootstrap.config().localAddress().toString(), -1, cause);
        }
        InetSocketAddress address = (InetSocketAddress)bootstrap.config().localAddress();
        return new ChannelBindException(address.getHostString(), address.getPort(), cause);
    }

    protected ChannelBindException(String localHost, int localPort, @Nullable Throwable cause) {
        super("Failed to bind on [" + localHost + ":" + localPort + "]", cause);
        this.localHost = localHost;
        this.localPort = localPort;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public String localHost() {
        return this.localHost;
    }

    public int localPort() {
        return this.localPort;
    }
}

