/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import io.milvus.exception.IllegalResponseException;
import io.milvus.exception.ParamException;
import io.milvus.grpc.ArrayArray;
import io.milvus.grpc.DataType;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.ScalarField;
import io.milvus.grpc.SparseFloatArray;
import io.milvus.param.ParamUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.NonNull;

public class FieldDataWrapper {
    private final FieldData fieldData;

    public FieldDataWrapper(@NonNull FieldData fieldData) {
        if (fieldData == null) {
            throw new NullPointerException("fieldData is marked non-null but is null");
        }
        this.fieldData = fieldData;
    }

    public boolean isVectorField() {
        return ParamUtils.isVectorDataType(this.fieldData.getType());
    }

    public boolean isJsonField() {
        return this.fieldData.getType() == DataType.JSON;
    }

    public boolean isDynamicField() {
        return this.fieldData.getType() == DataType.JSON && this.fieldData.getIsDynamic();
    }

    public int getDim() throws IllegalResponseException {
        if (!this.isVectorField()) {
            throw new IllegalResponseException("Not a vector field");
        }
        return (int)this.fieldData.getVectors().getDim();
    }

    private int checkDim(DataType dt, ByteString data, int dim) {
        if (dt == DataType.BinaryVector) {
            if (data.size() * 8 % dim != 0) {
                String msg = String.format("Returned binary vector data array size %d doesn't match dimension %d", data.size(), dim);
                throw new IllegalResponseException(msg);
            }
            return dim / 8;
        }
        if (dt == DataType.Float16Vector || dt == DataType.BFloat16Vector) {
            if (data.size() % (dim * 2) != 0) {
                String msg = String.format("Returned float16 vector data array size %d doesn't match dimension %d", data.size(), dim);
                throw new IllegalResponseException(msg);
            }
            return dim * 2;
        }
        return 0;
    }

    public long getRowCount() throws IllegalResponseException {
        DataType dt = this.fieldData.getType();
        switch (dt) {
            case FloatVector: {
                int dim = this.getDim();
                List<Float> data = this.fieldData.getVectors().getFloatVector().getDataList();
                if (data.size() % dim != 0) {
                    String msg = String.format("Returned float vector data array size %d doesn't match dimension %d", data.size(), dim);
                    throw new IllegalResponseException(msg);
                }
                return data.size() / dim;
            }
            case BinaryVector: {
                int dim = this.getDim();
                ByteString data = this.fieldData.getVectors().getBinaryVector();
                int bytePerVec = this.checkDim(dt, data, dim);
                return data.size() / bytePerVec;
            }
            case Float16Vector: 
            case BFloat16Vector: {
                int dim = this.getDim();
                ByteString data = dt == DataType.Float16Vector ? this.fieldData.getVectors().getFloat16Vector() : this.fieldData.getVectors().getBfloat16Vector();
                int bytePerVec = this.checkDim(dt, data, dim);
                return data.size() / bytePerVec;
            }
            case SparseFloatVector: {
                return this.fieldData.getVectors().getSparseFloatVector().getContentsCount();
            }
            case Int64: {
                return this.fieldData.getScalars().getLongData().getDataCount();
            }
            case Int32: 
            case Int16: 
            case Int8: {
                return this.fieldData.getScalars().getIntData().getDataCount();
            }
            case Bool: {
                return this.fieldData.getScalars().getBoolData().getDataCount();
            }
            case Float: {
                return this.fieldData.getScalars().getFloatData().getDataCount();
            }
            case Double: {
                return this.fieldData.getScalars().getDoubleData().getDataCount();
            }
            case VarChar: 
            case String: {
                return this.fieldData.getScalars().getStringData().getDataCount();
            }
            case JSON: {
                return this.fieldData.getScalars().getJsonData().getDataCount();
            }
            case Array: {
                return this.fieldData.getScalars().getArrayData().getDataCount();
            }
        }
        throw new IllegalResponseException("Unsupported data type returned by FieldData");
    }

    public List<?> getFieldData() throws IllegalResponseException {
        DataType dt = this.fieldData.getType();
        switch (dt) {
            case FloatVector: {
                int dim = this.getDim();
                List<Float> data = this.fieldData.getVectors().getFloatVector().getDataList();
                if (data.size() % dim != 0) {
                    String msg = String.format("Returned float vector data array size %d doesn't match dimension %d", data.size(), dim);
                    throw new IllegalResponseException(msg);
                }
                ArrayList<List<Float>> packData = new ArrayList<List<Float>>();
                int count = data.size() / dim;
                for (int i = 0; i < count; ++i) {
                    packData.add(data.subList(i * dim, (i + 1) * dim));
                }
                return packData;
            }
            case BinaryVector: 
            case Float16Vector: 
            case BFloat16Vector: {
                int dim = this.getDim();
                ByteString data = null;
                data = dt == DataType.BinaryVector ? this.fieldData.getVectors().getBinaryVector() : (dt == DataType.Float16Vector ? this.fieldData.getVectors().getFloat16Vector() : this.fieldData.getVectors().getBfloat16Vector());
                int bytePerVec = this.checkDim(dt, data, dim);
                int count = data.size() / bytePerVec;
                ArrayList<ByteBuffer> packData = new ArrayList<ByteBuffer>();
                for (int i = 0; i < count; ++i) {
                    ByteBuffer bf = ByteBuffer.allocate(bytePerVec);
                    bf.put(data.substring(i * bytePerVec, (i + 1) * bytePerVec).toByteArray());
                    packData.add(bf);
                }
                return packData;
            }
            case SparseFloatVector: {
                SparseFloatArray sparseArray = this.fieldData.getVectors().getSparseFloatVector();
                ArrayList packData = new ArrayList();
                for (int i = 0; i < sparseArray.getContentsCount(); ++i) {
                    ByteString bs = sparseArray.getContents(i);
                    ByteBuffer bf = ByteBuffer.wrap(bs.toByteArray());
                    bf.order(ByteOrder.LITTLE_ENDIAN);
                    TreeMap<Long, Float> sparse = new TreeMap<Long, Float>();
                    long num = bf.limit() / 8;
                    for (long j = 0L; j < num; ++j) {
                        ByteBuffer pBuf = ByteBuffer.allocate(8);
                        pBuf.order(ByteOrder.LITTLE_ENDIAN);
                        int offset = 8 * (int)j;
                        byte[] aa = bf.array();
                        for (int k = offset; k < offset + 4; ++k) {
                            pBuf.put(aa[k]);
                        }
                        pBuf.putInt(0);
                        pBuf.rewind();
                        long k = pBuf.getLong();
                        bf.position(offset + 4);
                        float v = bf.getFloat();
                        sparse.put(k, Float.valueOf(v));
                    }
                    packData.add(sparse);
                }
                return packData;
            }
            case Array: {
                ArrayList array = new ArrayList();
                ArrayArray arrArray = this.fieldData.getScalars().getArrayData();
                for (int i = 0; i < arrArray.getDataCount(); ++i) {
                    ScalarField scalar = arrArray.getData(i);
                    array.add(this.getScalarData(arrArray.getElementType(), scalar));
                }
                return array;
            }
            case Int64: 
            case Int32: 
            case Int16: 
            case Int8: 
            case Bool: 
            case Float: 
            case Double: 
            case VarChar: 
            case String: 
            case JSON: {
                return this.getScalarData(dt, this.fieldData.getScalars());
            }
        }
        throw new IllegalResponseException("Unsupported data type returned by FieldData");
    }

    private List<?> getScalarData(DataType dt, ScalarField scalar) {
        switch (dt) {
            case Int64: {
                return scalar.getLongData().getDataList();
            }
            case Int32: 
            case Int16: 
            case Int8: {
                return scalar.getIntData().getDataList();
            }
            case Bool: {
                return scalar.getBoolData().getDataList();
            }
            case Float: {
                return scalar.getFloatData().getDataList();
            }
            case Double: {
                return scalar.getDoubleData().getDataList();
            }
            case VarChar: 
            case String: {
                ProtocolStringList protoStrList = scalar.getStringData().getDataList();
                return protoStrList.subList(0, protoStrList.size());
            }
            case JSON: {
                List<ByteString> dataList = scalar.getJsonData().getDataList();
                return dataList.stream().map(ByteString::toStringUtf8).collect(Collectors.toList());
            }
        }
        return new ArrayList();
    }

    public Integer getAsInt(int index, String paramName) throws IllegalResponseException {
        if (this.isJsonField()) {
            String result = this.getAsString(index, paramName);
            return result == null ? null : Integer.valueOf(Integer.parseInt(result));
        }
        throw new IllegalResponseException("Only JSON type support this operation");
    }

    public String getAsString(int index, String paramName) throws IllegalResponseException {
        if (this.isJsonField()) {
            JSONObject jsonObject = this.parseObjectData(index);
            return jsonObject.getString(paramName);
        }
        throw new IllegalResponseException("Only JSON type support this operation");
    }

    public Boolean getAsBool(int index, String paramName) throws IllegalResponseException {
        if (this.isJsonField()) {
            String result = this.getAsString(index, paramName);
            return result == null ? null : Boolean.valueOf(Boolean.parseBoolean(result));
        }
        throw new IllegalResponseException("Only JSON type support this operation");
    }

    public Double getAsDouble(int index, String paramName) throws IllegalResponseException {
        if (this.isJsonField()) {
            String result = this.getAsString(index, paramName);
            return result == null ? null : Double.valueOf(Double.parseDouble(result));
        }
        throw new IllegalResponseException("Only JSON type support this operation");
    }

    public Object get(int index, String paramName) throws IllegalResponseException {
        if (this.isJsonField()) {
            JSONObject jsonObject = this.parseObjectData(index);
            return jsonObject.get((Object)paramName);
        }
        throw new IllegalResponseException("Only JSON type support this operation");
    }

    public Object valueByIdx(int index) throws ParamException {
        List<?> data = this.getFieldData();
        if (index < 0 || index >= data.size()) {
            throw new ParamException(String.format("Value index %d out of range %d", index, data.size()));
        }
        return data.get(index);
    }

    private JSONObject parseObjectData(int index) {
        Object object = this.valueByIdx(index);
        return FieldDataWrapper.ParseJSONObject(object);
    }

    public static JSONObject ParseJSONObject(Object object) {
        if (object instanceof String) {
            return JSONObject.parseObject((String)((String)object));
        }
        if (object instanceof byte[]) {
            return JSONObject.parseObject((String)new String((byte[])object));
        }
        throw new IllegalResponseException("Illegal type value for JSON parser");
    }
}

