/*
 * Decompiled with CFR 0.152.
 */
package io.kaitai.struct;

import io.kaitai.struct.KaitaiStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RandomAccessFileKaitaiStream
extends KaitaiStream {
    protected RandomAccessFile raf;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public RandomAccessFileKaitaiStream(String fileName) throws IOException {
        this.raf = new RandomAccessFile(fileName, "r");
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public boolean isEof() {
        try {
            return this.raf.getFilePointer() >= this.raf.length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void seek(int newPos) {
        try {
            this.raf.seek(newPos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void seek(long newPos) {
        try {
            this.raf.seek(newPos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int pos() {
        try {
            return (int)this.raf.getFilePointer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long size() {
        try {
            return this.raf.length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte readS1() {
        try {
            int t = this.raf.read();
            if (t < 0) {
                throw new EOFException();
            }
            return (byte)t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public short readS2be() {
        try {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            if ((b1 | b2) < 0) {
                throw new EOFException();
            }
            return (short)((b1 << 8) + (b2 << 0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int readS4be() {
        try {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            int b3 = this.raf.read();
            int b4 = this.raf.read();
            if ((b1 | b2 | b3 | b4) < 0) {
                throw new EOFException();
            }
            return (b1 << 24) + (b2 << 16) + (b3 << 8) + (b4 << 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long readS8be() {
        long b1 = this.readU4be();
        long b2 = this.readU4be();
        return (b1 << 32) + (b2 << 0);
    }

    public short readS2le() {
        try {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            if ((b1 | b2) < 0) {
                throw new EOFException();
            }
            return (short)((b2 << 8) + (b1 << 0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int readS4le() {
        try {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            int b3 = this.raf.read();
            int b4 = this.raf.read();
            if ((b1 | b2 | b3 | b4) < 0) {
                throw new EOFException();
            }
            return (b4 << 24) + (b3 << 16) + (b2 << 8) + (b1 << 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long readS8le() {
        long b1 = this.readU4le();
        long b2 = this.readU4le();
        return (b2 << 32) + (b1 << 0);
    }

    public int readU1() {
        try {
            int t = this.raf.read();
            if (t < 0) {
                throw new EOFException();
            }
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int readU2be() {
        try {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            if ((b1 | b2) < 0) {
                throw new EOFException();
            }
            return (b1 << 8) + (b2 << 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long readU4be() {
        try {
            long b1 = this.raf.read();
            long b2 = this.raf.read();
            long b3 = this.raf.read();
            long b4 = this.raf.read();
            if ((b1 | b2 | b3 | b4) < 0L) {
                throw new EOFException();
            }
            return (b1 << 24) + (b2 << 16) + (b3 << 8) + (b4 << 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int readU2le() {
        try {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            if ((b1 | b2) < 0) {
                throw new EOFException();
            }
            return (b2 << 8) + (b1 << 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long readU4le() {
        try {
            long b1 = this.raf.read();
            long b2 = this.raf.read();
            long b3 = this.raf.read();
            long b4 = this.raf.read();
            if ((b1 | b2 | b3 | b4) < 0L) {
                throw new EOFException();
            }
            return (b4 << 24) + (b3 << 16) + (b2 << 8) + (b1 << 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public float readF4be() {
        return this.wrapBufferBe(4).getFloat();
    }

    public double readF8be() {
        return this.wrapBufferBe(8).getDouble();
    }

    public float readF4le() {
        return this.wrapBufferLe(4).getFloat();
    }

    public double readF8le() {
        return this.wrapBufferLe(8).getDouble();
    }

    public byte[] readBytes(long n) {
        byte[] buf = new byte[this.toByteArrayLength(n)];
        try {
            int readCount = this.raf.read(buf);
            if ((long)readCount < n) {
                throw new EOFException();
            }
            return buf;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] readBytesFull() {
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int readCount;
            while (-1 != (readCount = this.raf.read(buffer))) {
                baos.write(buffer, 0, readCount);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] readBytesTerm(int term, boolean includeTerm, boolean consumeTerm, boolean eosError) {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            while (true) {
                int c;
                if ((c = this.raf.read()) < 0) {
                    if (eosError) {
                        throw new RuntimeException("End of stream reached, but no terminator " + term + " found");
                    }
                    return buf.toByteArray();
                }
                if (c == term) {
                    if (includeTerm) {
                        buf.write(c);
                    }
                    if (!consumeTerm) {
                        this.raf.seek(this.raf.getFilePointer() - 1L);
                    }
                    return buf.toByteArray();
                }
                buf.write(c);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ByteBuffer wrapBufferLe(int count) {
        return ByteBuffer.wrap(this.readBytes(count)).order(ByteOrder.LITTLE_ENDIAN);
    }

    private ByteBuffer wrapBufferBe(int count) {
        return ByteBuffer.wrap(this.readBytes(count)).order(ByteOrder.BIG_ENDIAN);
    }
}

