/*
 * Decompiled with CFR 0.152.
 */
package io.kaitai.struct;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public abstract class KaitaiStream
implements Closeable {
    protected int bitsLeft = 0;
    protected long bits = 0L;
    private static final int ZLIB_BUF_SIZE = 4096;

    public abstract void close() throws IOException;

    public abstract boolean isEof();

    public abstract void seek(int var1);

    public abstract void seek(long var1);

    public abstract int pos();

    public abstract long size();

    public abstract byte readS1();

    public abstract short readS2be();

    public abstract int readS4be();

    public abstract long readS8be();

    public abstract short readS2le();

    public abstract int readS4le();

    public abstract long readS8le();

    public abstract int readU1();

    public abstract int readU2be();

    public abstract long readU4be();

    public long readU8be() {
        return this.readS8be();
    }

    public abstract int readU2le();

    public abstract long readU4le();

    public long readU8le() {
        return this.readS8le();
    }

    public abstract float readF4be();

    public abstract double readF8be();

    public abstract float readF4le();

    public abstract double readF8le();

    public void alignToByte() {
        this.bits = 0L;
        this.bitsLeft = 0;
    }

    public long readBitsInt(int n) {
        int bitsNeeded = n - this.bitsLeft;
        if (bitsNeeded > 0) {
            byte[] buf;
            int bytesNeeded = (bitsNeeded - 1) / 8 + 1;
            for (byte b : buf = this.readBytes(bytesNeeded)) {
                this.bits <<= 8;
                this.bits |= (long)(b & 0xFF);
                this.bitsLeft += 8;
            }
        }
        long mask = KaitaiStream.getMaskOnes(n);
        int shiftBits = this.bitsLeft - n;
        long res = (this.bits & (mask <<= shiftBits)) >>> shiftBits;
        this.bitsLeft -= n;
        mask = KaitaiStream.getMaskOnes(this.bitsLeft);
        this.bits &= mask;
        return res;
    }

    private static long getMaskOnes(int n) {
        if (n == 64) {
            return -1L;
        }
        return (1L << n) - 1L;
    }

    public abstract byte[] readBytes(long var1);

    public abstract byte[] readBytesFull();

    public abstract byte[] readBytesTerm(int var1, boolean var2, boolean var3, boolean var4);

    public byte[] ensureFixedContents(byte[] expected) {
        byte[] actual = this.readBytes(expected.length);
        if (!Arrays.equals(actual, expected)) {
            throw new UnexpectedDataError(actual, expected);
        }
        return actual;
    }

    public static byte[] bytesStripRight(byte[] bytes, byte padByte) {
        int newLen;
        for (newLen = bytes.length; newLen > 0 && bytes[newLen - 1] == padByte; --newLen) {
        }
        return Arrays.copyOf(bytes, newLen);
    }

    public static byte[] bytesTerminate(byte[] bytes, byte term, boolean includeTerm) {
        int newLen;
        int maxLen = bytes.length;
        for (newLen = 0; bytes[newLen] != term && newLen < maxLen; ++newLen) {
        }
        if (includeTerm && newLen < maxLen) {
            ++newLen;
        }
        return Arrays.copyOf(bytes, newLen);
    }

    protected int toByteArrayLength(long n) {
        if (n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java byte arrays can be indexed only up to 31 bits, but " + n + " size was requested");
        }
        if (n < 0L) {
            throw new IllegalArgumentException("Byte array size can't be negative, but " + n + " size was requested");
        }
        return (int)n;
    }

    public static byte[] processXor(byte[] data, int key) {
        int dataLen = data.length;
        byte[] r = new byte[dataLen];
        for (int i = 0; i < dataLen; ++i) {
            r[i] = (byte)(data[i] ^ key);
        }
        return r;
    }

    public static byte[] processXor(byte[] data, byte[] key) {
        int dataLen = data.length;
        int valueLen = key.length;
        byte[] r = new byte[dataLen];
        int j = 0;
        for (int i = 0; i < dataLen; ++i) {
            r[i] = (byte)(data[i] ^ key[j]);
            j = (j + 1) % valueLen;
        }
        return r;
    }

    public static byte[] processRotateLeft(byte[] data, int amount, int groupSize) {
        byte[] r = new byte[data.length];
        switch (groupSize) {
            case 1: {
                for (int i = 0; i < data.length; ++i) {
                    byte bits = data[i];
                    r[i] = (byte)((bits & 0xFF) << amount | (bits & 0xFF) >>> 8 - amount);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("unable to rotate group of " + groupSize + " bytes yet");
            }
        }
        return r;
    }

    public static byte[] processZlib(byte[] data) {
        Inflater ifl = new Inflater();
        ifl.setInput(data);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while (!ifl.finished()) {
            try {
                int decBytes = ifl.inflate(buf);
                baos.write(buf, 0, decBytes);
            }
            catch (DataFormatException e) {
                throw new RuntimeException(e);
            }
        }
        ifl.end();
        return baos.toByteArray();
    }

    public static int mod(int a, int b) {
        if (b <= 0) {
            throw new ArithmeticException("mod divisor <= 0");
        }
        int r = a % b;
        if (r < 0) {
            r += b;
        }
        return r;
    }

    public static long mod(long a, long b) {
        if (b <= 0L) {
            throw new ArithmeticException("mod divisor <= 0");
        }
        long r = a % b;
        if (r < 0L) {
            r += b;
        }
        return r;
    }

    public static int byteArrayCompare(byte[] a, byte[] b) {
        if (a == b) {
            return 0;
        }
        int al = a.length;
        int bl = b.length;
        int minLen = Math.min(al, bl);
        for (int i = 0; i < minLen; ++i) {
            int cmp = (a[i] & 0xFF) - (b[i] & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        if (al == bl) {
            return 0;
        }
        return al - bl;
    }

    public static class UndecidedEndiannessError
    extends RuntimeException {
    }

    public static class UnexpectedDataError
    extends RuntimeException {
        public UnexpectedDataError(byte[] actual, byte[] expected) {
            super("Unexpected fixed contents: got " + UnexpectedDataError.byteArrayToHex(actual) + ", was waiting for " + UnexpectedDataError.byteArrayToHex(expected));
        }

        private static String byteArrayToHex(byte[] arr) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(String.format("%02x", arr[i]));
            }
            return sb.toString();
        }
    }
}

