/*
 * Decompiled with CFR 0.152.
 */
package io.github.burukeyou.dataframe.iframe;

import io.github.burukeyou.dataframe.iframe.IFrame;
import io.github.burukeyou.dataframe.iframe.JDFrameImpl;
import io.github.burukeyou.dataframe.iframe.WindowJDFrame;
import io.github.burukeyou.dataframe.iframe.function.ConsumerIndex;
import io.github.burukeyou.dataframe.iframe.function.NumberFunction;
import io.github.burukeyou.dataframe.iframe.function.ReplenishFunction;
import io.github.burukeyou.dataframe.iframe.function.SetFunction;
import io.github.burukeyou.dataframe.iframe.item.FI2;
import io.github.burukeyou.dataframe.iframe.item.FI3;
import io.github.burukeyou.dataframe.iframe.item.FI4;
import io.github.burukeyou.dataframe.iframe.support.Join;
import io.github.burukeyou.dataframe.iframe.support.JoinOn;
import io.github.burukeyou.dataframe.iframe.support.MaxMin;
import io.github.burukeyou.dataframe.iframe.window.Sorter;
import io.github.burukeyou.dataframe.iframe.window.Window;
import io.github.burukeyou.dataframe.util.FrameUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface JDFrame<T>
extends IFrame<T> {
    public static <R> JDFrame<R> read(List<R> list) {
        return new JDFrameImpl<R>(list);
    }

    public static <K, V> JDFrame<FI2<K, V>> read(Map<K, V> map) {
        return new JDFrameImpl<FI2<K, V>>(FrameUtil.toListFI2(map));
    }

    public static <K, J, V> JDFrame<FI3<K, J, V>> readMap(Map<K, Map<J, V>> map) {
        return new JDFrameImpl<FI3<K, J, V>>(FrameUtil.toListFI3(map));
    }

    @Override
    public <R> JDFrame<R> from(Stream<R> var1);

    @Override
    public JDFrame<T> forEachDo(Consumer<? super T> var1);

    @Override
    public JDFrame<T> forEachDo(ConsumerIndex<? super T> var1);

    @Override
    public JDFrame<T> defaultScale(int var1);

    @Override
    public JDFrame<T> defaultScale(int var1, RoundingMode var2);

    @Override
    public void show();

    @Override
    public void show(int var1);

    @Override
    public List<String> columns();

    @Override
    public <R> List<R> col(Function<T, R> var1);

    @Override
    public JDFrame<T> append(T var1);

    @Override
    public JDFrame<T> union(IFrame<T> var1);

    @Override
    public <R, K> JDFrame<R> join(IFrame<K> var1, JoinOn<T, K> var2, Join<T, K, R> var3);

    @Override
    public <R, K> JDFrame<R> join(IFrame<K> var1, JoinOn<T, K> var2);

    @Override
    public <R, K> JDFrame<R> leftJoin(IFrame<K> var1, JoinOn<T, K> var2, Join<T, K, R> var3);

    @Override
    public <R, K> JDFrame<R> leftJoin(IFrame<K> var1, JoinOn<T, K> var2);

    @Override
    public <R, K> JDFrame<R> rightJoin(IFrame<K> var1, JoinOn<T, K> var2, Join<T, K, R> var3);

    @Override
    public <R, K> JDFrame<R> rightJoin(IFrame<K> var1, JoinOn<T, K> var2);

    @Override
    public <R> JDFrame<R> map(Function<T, R> var1);

    @Override
    public <R extends Number> JDFrame<T> mapPercent(Function<T, R> var1, SetFunction<T, BigDecimal> var2, int var3);

    @Override
    public <R extends Number> JDFrame<T> mapPercent(Function<T, R> var1, SetFunction<T, BigDecimal> var2);

    @Override
    public JDFrame<List<T>> partition(int var1);

    @Override
    public JDFrame<FI2<T, Integer>> addRowNumberCol();

    @Override
    public JDFrame<FI2<T, Integer>> addRowNumberCol(Sorter<T> var1);

    @Override
    public JDFrame<T> addRowNumberCol(SetFunction<T, Integer> var1);

    @Override
    public JDFrame<T> addRowNumberCol(Sorter<T> var1, SetFunction<T, Integer> var2);

    @Override
    public JDFrame<FI2<T, Integer>> addRankCol(Sorter<T> var1);

    @Override
    public JDFrame<T> addRankCol(Sorter<T> var1, SetFunction<T, Integer> var2);

    @Override
    public JDFrame<T> sortDesc(Comparator<T> var1);

    @Override
    public <R extends Comparable<? super R>> JDFrame<T> sortDesc(Function<T, R> var1);

    @Override
    public JDFrame<T> sortAsc(Comparator<T> var1);

    @Override
    public <R extends Comparable<R>> JDFrame<T> sortAsc(Function<T, R> var1);

    @Override
    public JDFrame<T> cutFirst(int var1);

    @Override
    public JDFrame<T> cutLast(int var1);

    @Override
    public JDFrame<T> cut(Integer var1, Integer var2);

    @Override
    public JDFrame<T> cutPage(int var1, int var2);

    @Override
    public JDFrame<T> cutFirstRank(Sorter<T> var1, int var2);

    @Override
    public T head();

    @Override
    public List<T> head(int var1);

    @Override
    public T tail();

    @Override
    public List<T> tail(int var1);

    @Override
    public JDFrame<T> distinct();

    @Override
    public <R extends Comparable<R>> JDFrame<T> distinct(Function<T, R> var1);

    @Override
    public <R extends Comparable<R>> JDFrame<T> distinct(Comparator<T> var1);

    @Override
    public <R extends Comparable<R>> long countDistinct(Function<T, R> var1);

    @Override
    public long countDistinct(Comparator<T> var1);

    @Override
    public JDFrame<T> where(Predicate<? super T> var1);

    @Override
    public <R> JDFrame<T> whereNull(Function<T, R> var1);

    @Override
    public <R> JDFrame<T> whereNotNull(Function<T, R> var1);

    @Override
    public <R extends Comparable<R>> JDFrame<T> whereBetween(Function<T, R> var1, R var2, R var3);

    @Override
    public <R extends Comparable<R>> JDFrame<T> whereBetweenN(Function<T, R> var1, R var2, R var3);

    @Override
    public <R extends Comparable<R>> JDFrame<T> whereBetweenR(Function<T, R> var1, R var2, R var3);

    @Override
    public <R extends Comparable<R>> JDFrame<T> whereBetweenL(Function<T, R> var1, R var2, R var3);

    @Override
    public <R extends Comparable<R>> JDFrame<T> whereNotBetween(Function<T, R> var1, R var2, R var3);

    @Override
    public <R extends Comparable<R>> JDFrame<T> whereNotBetweenN(Function<T, R> var1, R var2, R var3);

    @Override
    public <R> JDFrame<T> whereIn(Function<T, R> var1, List<R> var2);

    @Override
    public <R> JDFrame<T> whereNotIn(Function<T, R> var1, List<R> var2);

    @Override
    public JDFrame<T> whereTrue(Predicate<T> var1);

    @Override
    public JDFrame<T> whereNotTrue(Predicate<T> var1);

    @Override
    public <R> JDFrame<T> whereEq(Function<T, R> var1, R var2);

    @Override
    public <R> JDFrame<T> whereNotEq(Function<T, R> var1, R var2);

    @Override
    public <R extends Comparable<R>> JDFrame<T> whereGt(Function<T, R> var1, R var2);

    @Override
    public <R extends Comparable<R>> JDFrame<T> whereGe(Function<T, R> var1, R var2);

    @Override
    public <R extends Comparable<R>> JDFrame<T> whereLt(Function<T, R> var1, R var2);

    @Override
    public <R extends Comparable<R>> JDFrame<T> whereLe(Function<T, R> var1, R var2);

    @Override
    public <R> JDFrame<T> whereLike(Function<T, R> var1, R var2);

    @Override
    public <R> JDFrame<T> whereNotLike(Function<T, R> var1, R var2);

    @Override
    public <R> JDFrame<T> whereLikeLeft(Function<T, R> var1, R var2);

    @Override
    public <R> JDFrame<T> whereLikeRight(Function<T, R> var1, R var2);

    @Override
    public <R> BigDecimal sum(Function<T, R> var1);

    @Override
    public <R> BigDecimal avg(Function<T, R> var1);

    @Override
    public <R extends Comparable<? super R>> MaxMin<T> maxMin(Function<T, R> var1);

    @Override
    public <R extends Comparable<? super R>> MaxMin<R> maxMinValue(Function<T, R> var1);

    @Override
    public <R extends Comparable<R>> T max(Function<T, R> var1);

    @Override
    public <R extends Comparable<? super R>> R maxValue(Function<T, R> var1);

    @Override
    public <R extends Comparable<? super R>> R minValue(Function<T, R> var1);

    @Override
    public <R extends Comparable<R>> T min(Function<T, R> var1);

    @Override
    public long count();

    @Override
    public <K> JDFrame<FI2<K, List<T>>> group(Function<? super T, ? extends K> var1);

    @Override
    public <K, R extends Number> JDFrame<FI2<K, BigDecimal>> groupBySum(Function<T, K> var1, NumberFunction<T, R> var2);

    @Override
    public <K, J, R extends Number> JDFrame<FI3<K, J, BigDecimal>> groupBySum(Function<T, K> var1, Function<T, J> var2, NumberFunction<T, R> var3);

    @Override
    public <K, J, H, R extends Number> JDFrame<FI4<K, J, H, BigDecimal>> groupBySum(Function<T, K> var1, Function<T, J> var2, Function<T, H> var3, NumberFunction<T, R> var4);

    @Override
    public <K> JDFrame<FI2<K, Long>> groupByCount(Function<T, K> var1);

    @Override
    public <K, J> JDFrame<FI3<K, J, Long>> groupByCount(Function<T, K> var1, Function<T, J> var2);

    @Override
    public <K, J, H> JDFrame<FI4<K, J, H, Long>> groupByCount(Function<T, K> var1, Function<T, J> var2, Function<T, H> var3);

    @Override
    public <K, R extends Number> JDFrame<FI3<K, BigDecimal, Long>> groupBySumCount(Function<T, K> var1, NumberFunction<T, R> var2);

    @Override
    public <K, J, R extends Number> JDFrame<FI4<K, J, BigDecimal, Long>> groupBySumCount(Function<T, K> var1, Function<T, J> var2, NumberFunction<T, R> var3);

    @Override
    public <K, R extends Number> JDFrame<FI2<K, BigDecimal>> groupByAvg(Function<T, K> var1, NumberFunction<T, R> var2);

    @Override
    public <K, J, R extends Number> JDFrame<FI3<K, J, BigDecimal>> groupByAvg(Function<T, K> var1, Function<T, J> var2, NumberFunction<T, R> var3);

    @Override
    public <K, J, H, R extends Number> JDFrame<FI4<K, J, H, BigDecimal>> groupByAvg(Function<T, K> var1, Function<T, J> var2, Function<T, H> var3, NumberFunction<T, R> var4);

    @Override
    public <K, V extends Comparable<? super V>> JDFrame<FI2<K, T>> groupByMax(Function<T, K> var1, Function<T, V> var2);

    @Override
    public <K, J, V extends Comparable<? super V>> JDFrame<FI3<K, J, T>> groupByMax(Function<T, K> var1, Function<T, J> var2, Function<T, V> var3);

    @Override
    public <K, V extends Comparable<? super V>> JDFrame<FI2<K, V>> groupByMaxValue(Function<T, K> var1, Function<T, V> var2);

    @Override
    public <K, J, V extends Comparable<? super V>> JDFrame<FI3<K, J, V>> groupByMaxValue(Function<T, K> var1, Function<T, J> var2, Function<T, V> var3);

    @Override
    public <K, V extends Comparable<? super V>> JDFrame<FI2<K, T>> groupByMin(Function<T, K> var1, Function<T, V> var2);

    @Override
    public <K, J, V extends Comparable<? super V>> JDFrame<FI3<K, J, T>> groupByMin(Function<T, K> var1, Function<T, J> var2, Function<T, V> var3);

    @Override
    public <K, V extends Comparable<? super V>> JDFrame<FI2<K, V>> groupByMinValue(Function<T, K> var1, Function<T, V> var2);

    @Override
    public <K, J, V extends Comparable<? super V>> JDFrame<FI3<K, J, V>> groupByMinValue(Function<T, K> var1, Function<T, J> var2, Function<T, V> var3);

    @Override
    public <K, V extends Comparable<? super V>> JDFrame<FI2<K, MaxMin<V>>> groupByMaxMinValue(Function<T, K> var1, Function<T, V> var2);

    @Override
    public <K, J, V extends Comparable<? super V>> JDFrame<FI3<K, J, MaxMin<V>>> groupByMaxMinValue(Function<T, K> var1, Function<T, J> var2, Function<T, V> var3);

    @Override
    public <K, V extends Comparable<? super V>> JDFrame<FI2<K, MaxMin<T>>> groupByMaxMin(Function<T, K> var1, Function<T, V> var2);

    @Override
    public <K, J, V extends Comparable<? super V>> JDFrame<FI3<K, J, MaxMin<T>>> groupByMaxMin(Function<T, K> var1, Function<T, J> var2, Function<T, V> var3);

    public WindowJDFrame<T> window(Window<T> var1);

    public WindowJDFrame<T> window();

    public JDFrame<FI2<T, Integer>> overRowNumber(Window<T> var1);

    public JDFrame<FI2<T, Integer>> overRowNumber();

    public JDFrame<T> overRowNumberS(SetFunction<T, Integer> var1, Window<T> var2);

    public JDFrame<T> overRowNumberS(SetFunction<T, Integer> var1);

    public JDFrame<FI2<T, Integer>> overRank(Window<T> var1);

    public JDFrame<T> overRankS(SetFunction<T, Integer> var1, Window<T> var2);

    public JDFrame<FI2<T, Integer>> overDenseRank(Window<T> var1);

    public JDFrame<T> overDenseRankS(SetFunction<T, Integer> var1, Window<T> var2);

    public JDFrame<FI2<T, BigDecimal>> overPercentRank(Window<T> var1);

    public JDFrame<T> overPercentRankS(SetFunction<T, BigDecimal> var1, Window<T> var2);

    public JDFrame<FI2<T, BigDecimal>> overCumeDist(Window<T> var1);

    public JDFrame<T> overCumeDistS(SetFunction<T, BigDecimal> var1, Window<T> var2);

    public <F> JDFrame<FI2<T, F>> overLag(Window<T> var1, Function<T, F> var2, int var3);

    public <F> JDFrame<T> overLagS(SetFunction<T, F> var1, Window<T> var2, Function<T, F> var3, int var4);

    public <F> JDFrame<FI2<T, F>> overLag(Function<T, F> var1, int var2);

    public <F> JDFrame<T> overLagS(SetFunction<T, F> var1, Function<T, F> var2, int var3);

    public <F> JDFrame<FI2<T, F>> overLead(Window<T> var1, Function<T, F> var2, int var3);

    public <F> JDFrame<T> overLeadS(SetFunction<T, F> var1, Window<T> var2, Function<T, F> var3, int var4);

    public <F> JDFrame<FI2<T, F>> overLead(Function<T, F> var1, int var2);

    public <F> JDFrame<T> overLeadS(SetFunction<T, F> var1, Function<T, F> var2, int var3);

    public <F> JDFrame<FI2<T, F>> overNthValue(Window<T> var1, Function<T, F> var2, int var3);

    public <F> JDFrame<T> overNthValueS(SetFunction<T, F> var1, Window<T> var2, Function<T, F> var3, int var4);

    public <F> JDFrame<FI2<T, F>> overNthValue(Function<T, F> var1, int var2);

    public <F> JDFrame<T> overNthValueS(SetFunction<T, F> var1, Function<T, F> var2, int var3);

    public <F> JDFrame<FI2<T, F>> overFirstValue(Window<T> var1, Function<T, F> var2);

    public <F> JDFrame<T> overFirstValueS(SetFunction<T, F> var1, Window<T> var2, Function<T, F> var3);

    public <F> JDFrame<FI2<T, F>> overFirstValue(Function<T, F> var1);

    public <F> JDFrame<T> overFirstValueS(SetFunction<T, F> var1, Function<T, F> var2);

    public <F> JDFrame<FI2<T, F>> overLastValue(Window<T> var1, Function<T, F> var2);

    public <F> JDFrame<T> overLastValueS(SetFunction<T, F> var1, Window<T> var2, Function<T, F> var3);

    public <F> JDFrame<FI2<T, F>> overLastValue(Function<T, F> var1);

    public <F> JDFrame<T> overLastValueS(SetFunction<T, F> var1, Function<T, F> var2);

    public <F> JDFrame<FI2<T, BigDecimal>> overSum(Window<T> var1, Function<T, F> var2);

    public <F> JDFrame<FI2<T, BigDecimal>> overSum(Function<T, F> var1);

    public <F> JDFrame<T> overSumS(SetFunction<T, BigDecimal> var1, Window<T> var2, Function<T, F> var3);

    public <F> JDFrame<T> overSumS(SetFunction<T, BigDecimal> var1, Function<T, F> var2);

    public <F> JDFrame<FI2<T, BigDecimal>> overAvg(Window<T> var1, Function<T, F> var2);

    public <F> JDFrame<FI2<T, BigDecimal>> overAvg(Function<T, F> var1);

    public <F> JDFrame<T> overAvgS(SetFunction<T, BigDecimal> var1, Window<T> var2, Function<T, F> var3);

    public <F> JDFrame<T> overAvgS(SetFunction<T, BigDecimal> var1, Function<T, F> var2);

    public <F extends Comparable<? super F>> JDFrame<FI2<T, F>> overMaxValue(Window<T> var1, Function<T, F> var2);

    public <F extends Comparable<? super F>> JDFrame<FI2<T, F>> overMaxValue(Function<T, F> var1);

    public <F extends Comparable<? super F>> JDFrame<T> overMaxValueS(SetFunction<T, F> var1, Window<T> var2, Function<T, F> var3);

    public <F extends Comparable<? super F>> JDFrame<T> overMaxValueS(SetFunction<T, F> var1, Function<T, F> var2);

    public <F extends Comparable<? super F>> JDFrame<FI2<T, F>> overMinValue(Window<T> var1, Function<T, F> var2);

    public <F extends Comparable<? super F>> JDFrame<FI2<T, F>> overMinValue(Function<T, F> var1);

    public <F extends Comparable<? super F>> JDFrame<T> overMinValueS(SetFunction<T, F> var1, Window<T> var2, Function<T, F> var3);

    public <F extends Comparable<? super F>> JDFrame<T> overMinValueS(SetFunction<T, F> var1, Function<T, F> var2);

    public JDFrame<FI2<T, Integer>> overCount(Window<T> var1);

    public JDFrame<FI2<T, Integer>> overCount();

    public JDFrame<T> overCountS(SetFunction<T, Integer> var1, Window<T> var2);

    public JDFrame<T> overCountS(SetFunction<T, Integer> var1);

    public JDFrame<FI2<T, Integer>> overNtile(int var1);

    public JDFrame<FI2<T, Integer>> overNtile(Window<T> var1, int var2);

    public JDFrame<T> overNtileS(SetFunction<T, Integer> var1, Window<T> var2, int var3);

    public JDFrame<T> overNtileS(SetFunction<T, Integer> var1, int var2);

    @Override
    public <C> JDFrame<T> replenish(Function<T, C> var1, List<C> var2, Function<C, T> var3);

    @Override
    public <G, C> JDFrame<T> replenish(Function<T, G> var1, Function<T, C> var2, List<C> var3, ReplenishFunction<G, C, T> var4);

    @Override
    public <G, C> JDFrame<T> replenish(Function<T, G> var1, Function<T, C> var2, ReplenishFunction<G, C, T> var3);
}

