/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.open.utils.crypto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.iuap.open.utils.crypto.ByteGroup;
import com.yonyou.iuap.open.utils.crypto.CryptoException;
import com.yonyou.iuap.open.utils.crypto.EncryptionHolder;
import com.yonyou.iuap.open.utils.crypto.ErrorCode;
import com.yonyou.iuap.open.utils.crypto.PKCS7Encoder;
import com.yonyou.iuap.open.utils.crypto.SHA256;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Arrays;
import java.util.Base64;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventCrypto {
    private static Charset CHARSET = Charset.forName("utf-8");
    private static ObjectMapper mapper = new ObjectMapper();
    private byte[] aesKey;
    private String token;
    private String suiteKey;
    private static final Logger LOGGER = LoggerFactory.getLogger(EventCrypto.class);

    public EventCrypto(String token, String encodingAesKey, String suiteKey) throws CryptoException {
        if (encodingAesKey.length() != 43) {
            LOGGER.error("\u65e0\u6548\u7684 AES key");
            throw new CryptoException(ErrorCode.INVALID_AES_SYMMETRIC_KEY);
        }
        this.token = token;
        this.suiteKey = suiteKey;
        this.aesKey = Base64.getDecoder().decode(encodingAesKey + "=");
    }

    private byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(sourceNumber & 0xFF);
        orderBytes[2] = (byte)(sourceNumber >> 8 & 0xFF);
        orderBytes[1] = (byte)(sourceNumber >> 16 & 0xFF);
        orderBytes[0] = (byte)(sourceNumber >> 24 & 0xFF);
        return orderBytes;
    }

    private int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    public String getRandomStr() {
        String base = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public String encrypt(String randomStr, String text) throws CryptoException {
        ByteGroup byteCollector = new ByteGroup();
        byte[] randomStrBytes = randomStr.getBytes(CHARSET);
        byte[] textBytes = text.getBytes(CHARSET);
        byte[] networkBytesOrder = this.getNetworkBytesOrder(textBytes.length);
        byte[] suiteKeyBytes = this.suiteKey.getBytes(CHARSET);
        byteCollector.addBytes(randomStrBytes);
        byteCollector.addBytes(networkBytesOrder);
        byteCollector.addBytes(textBytes);
        byteCollector.addBytes(suiteKeyBytes);
        byte[] padBytes = PKCS7Encoder.encode(byteCollector.size());
        byteCollector.addBytes(padBytes);
        byte[] unencrypted = byteCollector.toBytes();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            return Base64.getEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            LOGGER.error("AES \u52a0\u5bc6\u5931\u8d25\uff0ccause: {}", (Object)e.toString());
            throw new CryptoException(ErrorCode.AES_ENCRYPT_FAILED, (Throwable)e);
        }
    }

    public String decrypt(String text) throws CryptoException {
        String from_suiteKey;
        String message;
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec key_spec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, (Key)key_spec, iv);
            byte[] encrypted = Base64.getDecoder().decode(text);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            LOGGER.error("AES \u89e3\u5bc6\u5931\u8d25, cause: {}", (Object)e.toString());
            throw new CryptoException(ErrorCode.AES_DECRYPT_FAILED, (Throwable)e);
        }
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int xmlLength = this.recoverNetworkBytesOrder(networkOrder);
            message = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), CHARSET);
            from_suiteKey = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), CHARSET);
        }
        catch (Exception e) {
            LOGGER.error("\u65e0\u6548\u7684 AES key");
            throw new CryptoException(ErrorCode.INVALID_AES_SYMMETRIC_KEY, (Throwable)e);
        }
        if (!from_suiteKey.equals(this.suiteKey)) {
            LOGGER.error("suiteKey \u6821\u9a8c\u5931\u8d25");
            throw new CryptoException(ErrorCode.INVALID_SUITE_KEY);
        }
        return message;
    }

    public String encryptMsg(String msg, long timestamp, String nonce) throws CryptoException {
        String encrypt = this.encrypt(this.getRandomStr(), msg);
        String signature = SHA256.sign(this.token, String.valueOf(timestamp), nonce, encrypt);
        return this.holderToJsonStr(new EncryptionHolder(signature, timestamp, nonce, encrypt));
    }

    public String encryptMsg(String msg) throws CryptoException {
        return this.encryptMsg(msg, System.currentTimeMillis(), this.getRandomStr());
    }

    public String decryptMsg(String msgSignature, long timestamp, String nonce, String encrypt) throws CryptoException {
        String signature = SHA256.sign(this.token, String.valueOf(timestamp), nonce, encrypt);
        if (!signature.equals(msgSignature)) {
            LOGGER.error("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff01");
            throw new CryptoException(ErrorCode.INVALID_SIGNATURE);
        }
        return this.decrypt(encrypt);
    }

    public String decryptMsg(String jsonMsg) throws CryptoException {
        EncryptionHolder holder = this.jsonToHolder(jsonMsg);
        return this.decryptMsg(holder.getSignature(), holder.getTimestamp(), holder.getNonce(), holder.getEncrypt());
    }

    public String decryptMsg(EncryptionHolder holder) throws CryptoException {
        return this.decryptMsg(holder.getSignature(), holder.getTimestamp(), holder.getNonce(), holder.getEncrypt());
    }

    public String holderToJsonStr(EncryptionHolder holder) throws CryptoException {
        try {
            return mapper.writeValueAsString((Object)holder);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("\u52a0\u5bc6\u6d88\u606f\u5e8f\u5217\u5316\u5931\u8d25");
            throw new CryptoException(ErrorCode.ENCRYPT_MESSAGE_SERIALIZE_FAILED, (Throwable)e);
        }
    }

    public EncryptionHolder jsonToHolder(String jsonStr) throws CryptoException {
        try {
            return (EncryptionHolder)mapper.readValue(jsonStr, EncryptionHolder.class);
        }
        catch (IOException e) {
            throw new CryptoException(ErrorCode.ENCRYPT_MESSAGE_DESERIALIZE_FAILED, (Throwable)e);
        }
    }
}

