/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.open.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BeanJsonConvertUtil {
    private static final ObjectMapper mObjectMapper = new ObjectMapper();
    private static final ObjectMapper mObjectMapperLowerCaseWithUnderScores = new ObjectMapper();

    public static String beanToJson(Object object) {
        if (object != null) {
            try {
                return mObjectMapper.writeValueAsString(object);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("bean to json exception", e);
            }
        }
        return "";
    }

    public static <T> T jsonToBean(String json, Class<T> classType) {
        if (StringUtils.isNotBlank((CharSequence)json) && classType != null) {
            try {
                return (T)mObjectMapper.readValue(json, classType);
            }
            catch (IOException e) {
                throw new RuntimeException("json to bean exception", e);
            }
        }
        return null;
    }

    public static <T> List<T> jsonToList(String json, Class<T> classType) {
        if (StringUtils.isNotBlank((CharSequence)json) && classType != null) {
            try {
                return (List)mObjectMapper.readValue(json, (JavaType)mObjectMapper.getTypeFactory().constructCollectionType(List.class, classType));
            }
            catch (IOException e) {
                throw new RuntimeException("json to list exception", e);
            }
        }
        return null;
    }

    public static <k, v> Map<k, v> jsonToMap(String json, Class<k> kType, Class<v> vType) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                return (Map)mObjectMapper.readValue(json, (JavaType)mObjectMapper.getTypeFactory().constructMapType(Map.class, kType, vType));
            }
            catch (IOException e) {
                throw new RuntimeException("json to Map exception", e);
            }
        }
        return null;
    }

    public static String beanToJsonByLowerCase(Object object) {
        if (object != null) {
            try {
                return mObjectMapperLowerCaseWithUnderScores.writeValueAsString(object);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("bean to json with lowerCase exception", e);
            }
        }
        return "";
    }

    public static <T> T jsonToBeanByLowerCase(String json, Class<T> classType) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                return (T)mObjectMapperLowerCaseWithUnderScores.readValue(json, classType);
            }
            catch (IOException e) {
                throw new RuntimeException("json to Bean with lowerCase exception", e);
            }
        }
        return null;
    }

    static {
        mObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mObjectMapperLowerCaseWithUnderScores.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mObjectMapperLowerCaseWithUnderScores.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.SnakeCaseStrategy());
    }
}

