/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.open.invoke;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.iuap.open.module.EventContent;
import com.yonyou.iuap.open.utils.crypto.EncryptionHolder;
import com.yonyou.iuap.open.utils.crypto.IsvEventCrypto;
import com.yonyou.iuap.open.utils.crypto.PrivateAppCrypto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventParamDecrypt {
    private static final Logger log = LoggerFactory.getLogger(EventParamDecrypt.class);

    public static EventContent paramDecrypt(EncryptionHolder holder, String suitKey, String suitSecret, String encodingAESKey) {
        IsvEventCrypto crypto = new IsvEventCrypto(suitSecret, encodingAESKey, suitKey);
        ObjectMapper mapper = new ObjectMapper();
        String decryptMessage = crypto.decryptMsg(holder);
        EventContent content = null;
        try {
            content = (EventContent)mapper.readValue(decryptMessage, EventContent.class);
        }
        catch (JsonProcessingException e) {
            log.error("\u53cd\u5e8f\u5217\u5316\u6d88\u606f\u5185\u5bb9\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return content;
    }

    public static EventContent selfAppParamDecrypt(EncryptionHolder holder, String appKey, String appSecret) {
        PrivateAppCrypto crypto = PrivateAppCrypto.newCrypto(appKey, appSecret);
        ObjectMapper mapper = new ObjectMapper();
        String decryptMessage = crypto.decryptMsg(holder);
        EventContent content = null;
        try {
            content = (EventContent)mapper.readValue(decryptMessage, EventContent.class);
        }
        catch (JsonProcessingException e) {
            log.error("\u53cd\u5e8f\u5217\u5316\u6d88\u606f\u5185\u5bb9\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return content;
    }
}

