/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.open.http.handler;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.RequestLine;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestRetryHandler
implements org.apache.http.client.HttpRequestRetryHandler {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestRetryHandler.class);
    private int retryCount;

    public HttpRequestRetryHandler() {
    }

    public HttpRequestRetryHandler(int retryCount) {
        this.retryCount = retryCount;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        if (executionCount >= this.retryCount) {
            RequestLine requestLine = null;
            if (context instanceof HttpClientContext) {
                requestLine = ((HttpClientContext)context).getRequest().getRequestLine();
            }
            log.info("[COMMON_exceed_retryCount]\u8d85\u51fa\u6700\u5927\u91cd\u8bd5\u6b21\u6570\uff01\uff01\uff01requestLine={},retryCount={}", (Object)requestLine, (Object)this.retryCount);
            return false;
        }
        if (exception instanceof NoHttpResponseException) {
            return true;
        }
        if (exception instanceof SSLHandshakeException) {
            return false;
        }
        if (exception instanceof InterruptedIOException) {
            return true;
        }
        if (exception instanceof UnknownHostException) {
            return false;
        }
        if (exception instanceof ConnectTimeoutException) {
            return false;
        }
        if (exception instanceof SSLException) {
            return false;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        return !(request instanceof HttpEntityEnclosingRequest);
    }
}

