/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.vikingDB;

import com.google.gson.TypeAdapter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;

class ObjectTypeAdapterRewrite
extends TypeAdapter<Object> {
    ObjectTypeAdapterRewrite() {
    }

    public Object read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                in.beginArray();
                while (in.hasNext()) {
                    list.add(this.read(in));
                }
                in.endArray();
                return list;
            }
            case BEGIN_OBJECT: {
                LinkedTreeMap map = new LinkedTreeMap();
                in.beginObject();
                while (in.hasNext()) {
                    map.put(in.nextName(), this.read(in));
                }
                in.endObject();
                return map;
            }
            case STRING: {
                return in.nextString();
            }
            case NUMBER: {
                BigDecimal decimalValue = new BigDecimal(in.nextString());
                if (decimalValue.compareTo(new BigDecimal(Long.MIN_VALUE)) < 0 || decimalValue.compareTo(new BigDecimal(Long.MAX_VALUE)) > 0) {
                    return decimalValue.doubleValue();
                }
                if (decimalValue.scale() > 0) {
                    return decimalValue.doubleValue();
                }
                return decimalValue.longValue();
            }
            case BOOLEAN: {
                return in.nextBoolean();
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public void write(JsonWriter out, Object value) throws IOException {
    }
}

