/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.metric.dropwizard;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.vladmihalcea.flexypool.common.ConfigurationProperties;
import com.vladmihalcea.flexypool.metric.dropwizard.DropwizardMetrics;
import com.vladmihalcea.flexypool.metric.dropwizard.MetricsLifeCycleCallback;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jMetricReporter
implements MetricsLifeCycleCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardMetrics.class);
    private Slf4jReporter slf4jReporter;
    private long metricLogReporterMillis;

    @Override
    public Slf4jMetricReporter init(ConfigurationProperties configurationProperties, MetricRegistry metricRegistry) {
        this.metricLogReporterMillis = configurationProperties.getMetricLogReporterMillis();
        if (this.metricLogReporterMillis > 0L) {
            this.slf4jReporter = Slf4jReporter.forRegistry((MetricRegistry)metricRegistry).outputTo(LOGGER).build();
        }
        return this;
    }

    public void start() {
        if (this.slf4jReporter != null) {
            this.slf4jReporter.start(this.metricLogReporterMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.slf4jReporter != null) {
            this.slf4jReporter.stop();
        }
    }
}

