/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.metric.dropwizard;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.vladmihalcea.flexypool.common.ConfigurationProperties;
import com.vladmihalcea.flexypool.metric.dropwizard.MetricsLifeCycleCallback;

public class JmxMetricReporter
implements MetricsLifeCycleCallback {
    private JmxReporter jmxReporter;

    @Override
    public JmxMetricReporter init(ConfigurationProperties configurationProperties, MetricRegistry metricRegistry) {
        if (configurationProperties.isJmxEnabled()) {
            this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).inDomain(this.getClass().getName() + "." + configurationProperties.getUniqueName()).build();
        }
        if (configurationProperties.isJmxAutoStart()) {
            this.start();
        }
        return this;
    }

    public void start() {
        if (this.jmxReporter != null) {
            this.jmxReporter.start();
        }
    }

    public void stop() {
        if (this.jmxReporter != null) {
            this.jmxReporter.stop();
        }
    }
}

