/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.metric.dropwizard;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.UniformReservoir;
import com.vladmihalcea.flexypool.common.ConfigurationProperties;
import com.vladmihalcea.flexypool.metric.AbstractMetrics;
import com.vladmihalcea.flexypool.metric.Histogram;
import com.vladmihalcea.flexypool.metric.Metrics;
import com.vladmihalcea.flexypool.metric.MetricsFactory;
import com.vladmihalcea.flexypool.metric.Timer;
import com.vladmihalcea.flexypool.metric.dropwizard.DropwizardHistogram;
import com.vladmihalcea.flexypool.metric.dropwizard.DropwizardTimer;
import com.vladmihalcea.flexypool.metric.dropwizard.JmxMetricReporter;
import com.vladmihalcea.flexypool.metric.dropwizard.MetricsLifeCycleCallback;
import com.vladmihalcea.flexypool.metric.dropwizard.ReservoirFactory;
import com.vladmihalcea.flexypool.metric.dropwizard.Slf4jMetricReporter;
import java.util.Collection;
import java.util.LinkedHashSet;

public class DropwizardMetrics
extends AbstractMetrics {
    public static final MetricsFactory FACTORY = new ReservoirMetricsFactory(new ReservoirFactory(){

        @Override
        public Reservoir newInstance(Class<? extends Metric> metricClass, String metricName) {
            return new ExponentiallyDecayingReservoir();
        }
    });
    public static final MetricsFactory UNIFORM_RESERVOIR_FACTORY = new ReservoirMetricsFactory(new ReservoirFactory(){

        @Override
        public Reservoir newInstance(Class<? extends Metric> metricClass, String metricName) {
            return new UniformReservoir();
        }
    });
    private final MetricRegistry metricRegistry;
    private final ReservoirFactory reservoirFactory;
    private final Collection<MetricsLifeCycleCallback> callbacks = new LinkedHashSet<MetricsLifeCycleCallback>();

    public DropwizardMetrics(ConfigurationProperties configurationProperties, MetricRegistry metricRegistry, ReservoirFactory reservoirFactory, MetricsLifeCycleCallback ... callbacks) {
        super(configurationProperties);
        this.metricRegistry = metricRegistry;
        this.reservoirFactory = reservoirFactory;
        this.callbacks.add(new Slf4jMetricReporter().init(configurationProperties, metricRegistry));
        this.callbacks.add(new JmxMetricReporter().init(configurationProperties, metricRegistry));
        for (MetricsLifeCycleCallback callback : callbacks) {
            this.callbacks.add(callback.init(configurationProperties, metricRegistry));
        }
    }

    public DropwizardMetrics(ConfigurationProperties configurationProperties, ReservoirFactory reservoirFactory, MetricsLifeCycleCallback ... callbacks) {
        this(configurationProperties, new MetricRegistry(), reservoirFactory, callbacks);
    }

    public Histogram histogram(String name) {
        com.codahale.metrics.Histogram histogram = new com.codahale.metrics.Histogram(this.reservoirFactory.newInstance(com.codahale.metrics.Histogram.class, name));
        return new DropwizardHistogram((com.codahale.metrics.Histogram)this.metricRegistry.register(name, (Metric)histogram));
    }

    public Timer timer(String name) {
        com.codahale.metrics.Timer timer = new com.codahale.metrics.Timer(this.reservoirFactory.newInstance(com.codahale.metrics.Timer.class, name));
        return new DropwizardTimer((com.codahale.metrics.Timer)this.metricRegistry.register(name, (Metric)timer));
    }

    public void start() {
        for (MetricsLifeCycleCallback callback : this.callbacks) {
            callback.start();
        }
    }

    public void stop() {
        for (MetricsLifeCycleCallback callback : this.callbacks) {
            callback.stop();
        }
    }

    public static class ReservoirMetricsFactory
    implements MetricsFactory {
        private final ReservoirFactory reservoirFactory;

        public ReservoirMetricsFactory(ReservoirFactory reservoirFactory) {
            this.reservoirFactory = reservoirFactory;
        }

        public Metrics newInstance(ConfigurationProperties configurationProperties) {
            return new DropwizardMetrics(configurationProperties, this.reservoirFactory, new MetricsLifeCycleCallback[0]);
        }
    }
}

