/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.http.httpclient;

import com.stormpath.sdk.client.AuthenticationScheme;
import com.stormpath.sdk.client.Proxy;
import com.stormpath.sdk.impl.authc.credentials.ClientCredentials;
import com.stormpath.sdk.impl.http.HttpHeaders;
import com.stormpath.sdk.impl.http.MediaType;
import com.stormpath.sdk.impl.http.QueryString;
import com.stormpath.sdk.impl.http.Request;
import com.stormpath.sdk.impl.http.RequestExecutor;
import com.stormpath.sdk.impl.http.Response;
import com.stormpath.sdk.impl.http.RestException;
import com.stormpath.sdk.impl.http.authc.DefaultRequestAuthenticatorFactory;
import com.stormpath.sdk.impl.http.authc.RequestAuthenticator;
import com.stormpath.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.stormpath.sdk.impl.http.httpclient.HttpClientRequestFactory;
import com.stormpath.sdk.impl.http.support.BackoffStrategy;
import com.stormpath.sdk.impl.http.support.DefaultRequest;
import com.stormpath.sdk.impl.http.support.DefaultResponse;
import com.stormpath.sdk.lang.Assert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Map;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRequestExecutor
implements RequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestExecutor.class);
    private static final int MAX_BACKOFF_IN_MILLISECONDS = 20000;
    private static final int DEFAULT_MAX_RETRIES = 4;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 0x3FFFFFFF;
    private static final String MAX_CONNECTIONS_PER_ROUTE_PROPERTY_KEY = "com.stormpath.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.maxPerRoute";
    private static final int MAX_CONNECTIONS_PER_ROUTE;
    private static final int DEFAULT_MAX_CONNECTIONS_TOTAL = Integer.MAX_VALUE;
    private static final String MAX_CONNECTIONS_TOTAL_PROPERTY_KEY = "com.stormpath.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.maxTotal";
    private static final int MAX_CONNECTIONS_TOTAL;
    private int numRetries = 4;
    private final RequestAuthenticator requestAuthenticator;
    private DefaultHttpClient httpClient;
    private BackoffStrategy backoffStrategy;
    private HttpClientRequestFactory httpClientRequestFactory;
    private final Random random = new Random();

    public HttpClientRequestExecutor(ClientCredentials clientCredentials, Proxy proxy, AuthenticationScheme authenticationScheme, RequestAuthenticatorFactory requestAuthenticatorFactory, Integer connectionTimeout) {
        Assert.notNull((Object)clientCredentials, (String)"clientCredentials argument is required.");
        Assert.isTrue((connectionTimeout >= 0 ? 1 : 0) != 0, (String)"Timeout cannot be a negative number.");
        RequestAuthenticatorFactory factory = requestAuthenticatorFactory != null ? requestAuthenticatorFactory : new DefaultRequestAuthenticatorFactory();
        this.requestAuthenticator = factory.create(authenticationScheme, clientCredentials);
        this.httpClientRequestFactory = new HttpClientRequestFactory();
        PoolingClientConnectionManager connMgr = new PoolingClientConnectionManager();
        if (MAX_CONNECTIONS_TOTAL >= MAX_CONNECTIONS_PER_ROUTE) {
            connMgr.setDefaultMaxPerRoute(MAX_CONNECTIONS_PER_ROUTE);
            connMgr.setMaxTotal(MAX_CONNECTIONS_TOTAL);
        } else {
            connMgr.setDefaultMaxPerRoute(0x3FFFFFFF);
            connMgr.setMaxTotal(Integer.MAX_VALUE);
            log.warn("{} ({}) is less than {} ({}). Reverting to defaults: connectionMaxTotal ({}) and connectionMaxPerRoute ({}).", new Object[]{MAX_CONNECTIONS_TOTAL_PROPERTY_KEY, MAX_CONNECTIONS_TOTAL, MAX_CONNECTIONS_PER_ROUTE_PROPERTY_KEY, MAX_CONNECTIONS_PER_ROUTE, Integer.MAX_VALUE, 0x3FFFFFFF});
        }
        int connectionTimeoutAsMilliseconds = connectionTimeout * 1000;
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)connMgr);
        this.httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        this.httpClient.getParams().setParameter("http.socket.timeout", (Object)connectionTimeoutAsMilliseconds);
        this.httpClient.getParams().setParameter("http.connection.timeout", (Object)connectionTimeoutAsMilliseconds);
        this.httpClient.getParams().setParameter("http.protocol.handle-redirects", (Object)false);
        this.httpClient.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        if (proxy != null) {
            HttpHost httpProxyHost = new HttpHost(proxy.getHost(), proxy.getPort());
            this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)httpProxyHost);
            if (proxy.isAuthenticationRequired()) {
                this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword()));
            }
        }
    }

    public int getNumRetries() {
        return this.numRetries;
    }

    public void setNumRetries(int numRetries) {
        this.numRetries = numRetries;
    }

    public BackoffStrategy getBackoffStrategy() {
        return this.backoffStrategy;
    }

    public void setBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
    }

    public void setHttpClient(DefaultHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response executeRequest(Request request) throws RestException {
        Assert.notNull((Object)request, (String)"Request argument cannot be null.");
        int retryCount = 0;
        URI redirectUri = null;
        HttpEntity entity = null;
        RestException exception = null;
        QueryString originalQuery = new QueryString();
        originalQuery.putAll((Map)request.getQueryString());
        HttpHeaders originalHeaders = new HttpHeaders();
        originalHeaders.putAll((Map)request.getHeaders());
        while (true) {
            if (redirectUri != null) {
                request = new DefaultRequest(request.getMethod(), redirectUri.toString(), null, null, request.getBody(), request.getHeaders().getContentLength());
            }
            if (retryCount > 0) {
                request.setQueryString(originalQuery);
                request.setHeaders(originalHeaders);
            }
            this.requestAuthenticator.authenticate(request);
            HttpRequestBase httpRequest = this.httpClientRequestFactory.createHttpClientRequest(request, entity);
            if (httpRequest instanceof HttpEntityEnclosingRequest) {
                entity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
            }
            CloseableHttpResponse httpResponse = null;
            try {
                if (retryCount > 0 && redirectUri == null) {
                    InputStream content;
                    this.pauseExponentially(retryCount, exception);
                    if (entity != null && (content = entity.getContent()).markSupported()) {
                        content.reset();
                    }
                }
                redirectUri = null;
                exception = null;
                ++retryCount;
                httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
                if (this.isRedirect((HttpResponse)httpResponse)) {
                    Header[] locationHeaders = httpResponse.getHeaders("Location");
                    String location = locationHeaders[0].getValue();
                    log.debug("Redirecting to: {}", (Object)location);
                    redirectUri = URI.create(location);
                    httpRequest.setURI(redirectUri);
                    continue;
                }
                Response response = this.toSdkResponse((HttpResponse)httpResponse);
                int httpStatus = response.getHttpStatus();
                if (httpStatus == 429) {
                    throw new RestException("HTTP 429: Too Many Requests.  Exceeded request rate limit in the allotted amount of time.");
                }
                if ((httpStatus == 503 || httpStatus == 504) && retryCount <= this.numRetries) continue;
                Response response2 = response;
                return response2;
            }
            catch (Throwable t) {
                log.warn("Unable to execute HTTP request: ", (Object)t.getMessage(), (Object)t);
                if (t instanceof RestException) {
                    exception = (RestException)t;
                }
                if (this.shouldRetry(httpRequest, t, retryCount)) continue;
                throw new RestException("Unable to execute HTTP request: " + t.getMessage(), t);
            }
            finally {
                try {
                    httpResponse.getEntity().getContent().close();
                }
                catch (Throwable response) {}
                continue;
            }
            break;
        }
    }

    private boolean isRedirect(HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return (status == 301 || status == 302 || status == 307) && response.getHeaders("Location") != null && response.getHeaders("Location").length > 0;
    }

    private void pauseExponentially(int retries, RestException previousException) {
        long delay;
        if (this.backoffStrategy != null) {
            delay = this.backoffStrategy.getDelayMillis(retries);
        } else {
            long scaleFactor = 300L;
            if (previousException != null && this.isThrottlingException(previousException)) {
                scaleFactor = 500 + this.random.nextInt(100);
            }
            delay = (long)(Math.pow(2.0, retries) * (double)scaleFactor);
        }
        delay = Math.min(delay, 20000L);
        log.debug("Retryable condition detected, will retry in {}ms, attempt number: {}", (Object)delay, (Object)retries);
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RestException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean shouldRetry(HttpRequestBase method, Throwable t, int retries) {
        RestException re;
        HttpEntity entity;
        if (retries > this.numRetries) {
            return false;
        }
        if (method instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)method).getEntity()) != null && !entity.isRepeatable()) {
            return false;
        }
        if (t instanceof NoHttpResponseException || t instanceof SocketException || t instanceof SocketTimeoutException || t instanceof ConnectTimeoutException) {
            log.debug("Retrying on {}: {}", (Object)t.getClass().getName(), (Object)t.getMessage());
            return true;
        }
        return t instanceof RestException && this.isThrottlingException(re = (RestException)t);
    }

    private boolean isThrottlingException(RestException re) {
        String msg = re.getMessage();
        return msg != null && msg.contains("HTTP 429");
    }

    protected byte[] toBytes(HttpEntity entity) throws IOException {
        return EntityUtils.toByteArray((HttpEntity)entity);
    }

    protected Response toSdkResponse(HttpResponse httpResponse) throws IOException {
        long contentLength;
        int httpStatus = httpResponse.getStatusLine().getStatusCode();
        HttpHeaders headers = this.getHeaders(httpResponse);
        MediaType mediaType = headers.getContentType();
        HttpEntity entity = this.getHttpEntity(httpResponse);
        InputStream body = entity != null ? entity.getContent() : null;
        long l = contentLength = entity != null ? entity.getContentLength() : -1L;
        if (body != null) {
            byte[] bytes = this.toBytes(entity);
            body = bytes != null ? new ByteArrayInputStream(bytes) : null;
        }
        DefaultResponse response = new DefaultResponse(httpStatus, mediaType, body, contentLength);
        response.getHeaders().add("Stormpath-Request-Id", headers.getStormpathRequestId());
        return response;
    }

    private HttpEntity getHttpEntity(HttpResponse response) {
        Header contentEncodingHeader;
        HttpEntity entity = response.getEntity();
        if (entity != null && (contentEncodingHeader = entity.getContentEncoding()) != null) {
            for (HeaderElement element : contentEncodingHeader.getElements()) {
                if (!element.getName().equalsIgnoreCase("gzip")) continue;
                return new GzipDecompressingEntity(response.getEntity());
            }
        }
        return entity;
    }

    private HttpHeaders getHeaders(HttpResponse response) {
        HttpHeaders headers = new HttpHeaders();
        Header[] httpHeaders = response.getAllHeaders();
        if (httpHeaders != null) {
            for (Header httpHeader : httpHeaders) {
                headers.add(httpHeader.getName(), httpHeader.getValue());
            }
        }
        return headers;
    }

    static {
        int connectionMaxPerRoute = 0x3FFFFFFF;
        String connectionMaxPerRouteString = System.getProperty(MAX_CONNECTIONS_PER_ROUTE_PROPERTY_KEY);
        if (connectionMaxPerRouteString != null) {
            try {
                connectionMaxPerRoute = Integer.parseInt(connectionMaxPerRouteString);
            }
            catch (NumberFormatException nfe) {
                log.warn("Bad max connection per route value: {}. Using default: {}.", new Object[]{connectionMaxPerRouteString, 0x3FFFFFFF, nfe});
            }
        }
        MAX_CONNECTIONS_PER_ROUTE = connectionMaxPerRoute;
        int connectionMaxTotal = Integer.MAX_VALUE;
        String connectionMaxTotalString = System.getProperty(MAX_CONNECTIONS_TOTAL_PROPERTY_KEY);
        if (connectionMaxTotalString != null) {
            try {
                connectionMaxTotal = Integer.parseInt(connectionMaxTotalString);
            }
            catch (NumberFormatException nfe) {
                log.warn("Bad max connection total value: {}. Using default: {}.", new Object[]{connectionMaxTotalString, Integer.MAX_VALUE, nfe});
            }
        }
        MAX_CONNECTIONS_TOTAL = connectionMaxTotal;
    }
}

