/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.view.AbstractViewAssert;

public class ImageViewAssert
extends AbstractViewAssert<ImageViewAssert, ImageView> {
    public ImageViewAssert(ImageView actual) {
        super(actual, ImageViewAssert.class);
    }

    public ImageViewAssert isAligningBaselineToBottom() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ImageView)this.actual).getBaselineAlignBottom()).overridingErrorMessage("Expected to be aligning baseline to bottom but was not.", new Object[0])).isTrue();
        return this;
    }

    public ImageViewAssert isNotAligningBaselineToBottom() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ImageView)this.actual).getBaselineAlignBottom()).overridingErrorMessage("Expected to not be aligning baseline to bottom but was.", new Object[0])).isFalse();
        return this;
    }

    public ImageViewAssert isCroppingToPadding() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ImageView)this.actual).getCropToPadding()).overridingErrorMessage("Expected to be cropping to padding but was not.", new Object[0])).isTrue();
        return this;
    }

    public ImageViewAssert isNotCroppingToPadding() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ImageView)this.actual).getCropToPadding()).overridingErrorMessage("Expected to not be cropping to padding but was.", new Object[0])).isFalse();
        return this;
    }

    public ImageViewAssert hasDrawable(Drawable drawable) {
        this.isNotNull();
        Drawable actualDrawable = ((ImageView)this.actual).getDrawable();
        ((ObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected drawable <%s> but was <%s>.", new Object[]{drawable, actualDrawable})).isSameAs((Object)drawable);
        return this;
    }

    public ImageViewAssert hasImageAlpha(int alpha) {
        this.isNotNull();
        int actualAlpha = ((ImageView)this.actual).getImageAlpha();
        ((IntegerAssert)Assertions.assertThat((int)actualAlpha).overridingErrorMessage("Expected image alpha <%s> but was <%s>.", new Object[]{alpha, actualAlpha})).isEqualTo(alpha);
        return this;
    }

    public ImageViewAssert hasScaleType(ImageView.ScaleType type) {
        this.isNotNull();
        ImageView.ScaleType actualType = ((ImageView)this.actual).getScaleType();
        ((ObjectAssert)Assertions.assertThat((Object)actualType).overridingErrorMessage("Expected scale type <%s> but was <%s>.", new Object[]{type, actualType})).isEqualTo((Object)type);
        return this;
    }
}

