/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view;

import android.view.View;
import android.view.ViewGroup;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.view.AbstractViewAssert;

public abstract class AbstractViewGroupAssert<S extends AbstractViewGroupAssert<S, A>, A extends ViewGroup>
extends AbstractViewAssert<S, A> {
    protected AbstractViewGroupAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S isAddingStatesFromChildren() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).addStatesFromChildren()).overridingErrorMessage("Expected adding states from children but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S isNotAddingStatesFromChildren() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).addStatesFromChildren()).overridingErrorMessage("Expected not adding states from children but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S hasChildCount(int count) {
        this.isNotNull();
        int actualCount = ((ViewGroup)this.actual).getChildCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected child count <%s> but was <%s>", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S hasDescendantFocusability(int focusability) {
        this.isNotNull();
        int actualFocusability = ((ViewGroup)this.actual).getDescendantFocusability();
        ((IntegerAssert)Assertions.assertThat((int)actualFocusability).overridingErrorMessage("Expected descendant focusability <%s> but was <%s>", new Object[]{AbstractViewGroupAssert.descendantFocusabilityToString(focusability), AbstractViewGroupAssert.descendantFocusabilityToString(actualFocusability)})).isEqualTo(focusability);
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S hasFocusedChild(View view) {
        this.isNotNull();
        View actualView = ((ViewGroup)this.actual).getFocusedChild();
        ((ObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected focused child <%s> but was <%s>", new Object[]{view, actualView})).isSameAs((Object)view);
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S hasPersistentDrawingCache(int cache) {
        this.isNotNull();
        int actualCache = ((ViewGroup)this.actual).getPersistentDrawingCache();
        ((IntegerAssert)Assertions.assertThat((int)actualCache).overridingErrorMessage("Expected persistent drawing cache <%s> but was <%s>", new Object[]{AbstractViewGroupAssert.persistentDrawingCacheToString(cache), AbstractViewGroupAssert.persistentDrawingCacheToString(actualCache)})).isEqualTo(cache);
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S isAlwaysDrawnWithCache() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).isAlwaysDrawnWithCacheEnabled()).overridingErrorMessage("Expected to always draw with cache but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S isNotAlwaysDrawnWithCache() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).isAlwaysDrawnWithCacheEnabled()).overridingErrorMessage("Expected to not always draw with cache but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S hasAnimationCacheEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).isAnimationCacheEnabled()).overridingErrorMessage("Expected animation cache enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S hasAnimationCacheDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).isAnimationCacheEnabled()).overridingErrorMessage("Expected animation cache disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S hasMotionEventSplittingEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).isMotionEventSplittingEnabled()).overridingErrorMessage("Expected motion event splitting enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S hasMotionEventSplittingDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).isMotionEventSplittingEnabled()).overridingErrorMessage("Expected motion event splitting disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    private static String descendantFocusabilityToString(int focusability) {
        switch (focusability) {
            case 262144: {
                return "afterDescendants";
            }
            case 131072: {
                return "beforeDescendants";
            }
            case 393216: {
                return "blockDescendants";
            }
        }
        throw new IllegalArgumentException("Unknown descendant focusability: " + focusability);
    }

    private static String persistentDrawingCacheToString(int cache) {
        switch (cache) {
            case 3: {
                return "all";
            }
            case 1: {
                return "animation";
            }
            case 0: {
                return "none";
            }
            case 2: {
                return "scrolling";
            }
        }
        throw new IllegalArgumentException("Unknown persistent drawing cache: " + cache);
    }
}

