/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.util;

import android.util.LruCache;
import java.util.Map;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.MapAssert;

public class LruCacheAssert<K, V>
extends AbstractAssert<LruCacheAssert<K, V>, LruCache<K, V>> {
    public LruCacheAssert(LruCache<K, V> actual) {
        super(actual, LruCacheAssert.class);
    }

    public LruCacheAssert<K, V> hasEntry(K key) {
        this.isNotNull();
        ((MapAssert)Assertions.assertThat((Map)((LruCache)this.actual).snapshot()).overridingErrorMessage("Expected to contain entry with key <%s> but did not.", new Object[0])).containsKey(key);
        return this;
    }

    public LruCacheAssert<K, V> hasCreateCount(int count) {
        this.isNotNull();
        int actualCount = ((LruCache)this.actual).createCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected create count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public LruCacheAssert<K, V> hasEvictionCount(int count) {
        this.isNotNull();
        int actualCount = ((LruCache)this.actual).evictionCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected eviction count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public LruCacheAssert<K, V> hasHitCount(int count) {
        this.isNotNull();
        int actualCount = ((LruCache)this.actual).hitCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected hit count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public LruCacheAssert<K, V> hasMaxSize(int size) {
        this.isNotNull();
        int actualSize = ((LruCache)this.actual).maxSize();
        ((IntegerAssert)Assertions.assertThat((int)actualSize).overridingErrorMessage("Expected max size <%s> but was <%s>.", new Object[]{size, actualSize})).isEqualTo(size);
        return this;
    }

    public LruCacheAssert<K, V> hasMissCount(int count) {
        this.isNotNull();
        int actualCount = ((LruCache)this.actual).missCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected miss count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public LruCacheAssert<K, V> hasPutCount(int count) {
        this.isNotNull();
        int actualCount = ((LruCache)this.actual).putCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected put count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public LruCacheAssert<K, V> hasSize(int size) {
        this.isNotNull();
        int actualSize = ((LruCache)this.actual).size();
        ((IntegerAssert)Assertions.assertThat((int)actualSize).overridingErrorMessage("Expected size <%s> but was <%s>.", new Object[]{size, actualSize})).isEqualTo(size);
        return this;
    }
}

