/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.location;

import android.location.GpsSatellite;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.IntegerAssert;

public class GpsSatelliteAssert
extends AbstractAssert<GpsSatelliteAssert, GpsSatellite> {
    public GpsSatelliteAssert(GpsSatellite actual) {
        super((Object)actual, GpsSatelliteAssert.class);
    }

    public GpsSatelliteAssert hasAzimuth(float azimuth) {
        this.isNotNull();
        float actualAzimuth = ((GpsSatellite)this.actual).getAzimuth();
        ((FloatAssert)Assertions.assertThat((float)actualAzimuth).overridingErrorMessage("Expected azimuth <%s> but was <%s>.", new Object[]{Float.valueOf(azimuth), Float.valueOf(actualAzimuth)})).isEqualTo(azimuth);
        return this;
    }

    public GpsSatelliteAssert hasElevation(float elevation) {
        this.isNotNull();
        float actualElevation = ((GpsSatellite)this.actual).getElevation();
        ((FloatAssert)Assertions.assertThat((float)actualElevation).overridingErrorMessage("Expected elevation <%s> but was <%s>.", new Object[]{Float.valueOf(elevation), Float.valueOf(actualElevation)})).isEqualTo(elevation);
        return this;
    }

    public GpsSatelliteAssert hasPrn(int prn) {
        this.isNotNull();
        int actualPrn = ((GpsSatellite)this.actual).getPrn();
        ((IntegerAssert)Assertions.assertThat((int)actualPrn).overridingErrorMessage("Expected PRN <%s> but was <%s>.", new Object[]{prn, actualPrn})).isEqualTo(prn);
        return this;
    }

    public GpsSatelliteAssert hasSnr(float snr) {
        this.isNotNull();
        float actualSnr = ((GpsSatellite)this.actual).getSnr();
        ((FloatAssert)Assertions.assertThat((float)actualSnr).overridingErrorMessage("Expected SNR <%s> but was <%s>.", new Object[]{Float.valueOf(snr), Float.valueOf(actualSnr)})).isEqualTo(snr);
        return this;
    }

    public GpsSatelliteAssert hasAlmanac() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GpsSatellite)this.actual).hasAlmanac()).overridingErrorMessage("Expected to have almanac but did not.", new Object[0])).isTrue();
        return this;
    }

    public GpsSatelliteAssert hasNoAlmanac() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GpsSatellite)this.actual).hasAlmanac()).overridingErrorMessage("Expected to not have almanac but did.", new Object[0])).isFalse();
        return this;
    }

    public GpsSatelliteAssert hasEphemeris() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GpsSatellite)this.actual).hasEphemeris()).overridingErrorMessage("Expected to have ephemeris but did not.", new Object[0])).isTrue();
        return this;
    }

    public GpsSatelliteAssert hasNotEphemeris() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GpsSatellite)this.actual).hasEphemeris()).overridingErrorMessage("Expected to not have ephemeris but did.", new Object[0])).isFalse();
        return this;
    }

    public GpsSatelliteAssert isUsedInFix() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GpsSatellite)this.actual).usedInFix()).overridingErrorMessage("Expected to be used in fix but was not.", new Object[0])).isTrue();
        return this;
    }

    public GpsSatelliteAssert isNotUsedInFix() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GpsSatellite)this.actual).usedInFix()).overridingErrorMessage("Expected to not be used in fix but was.", new Object[0])).isFalse();
        return this;
    }
}

