/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.gesture;

import android.gesture.GestureStroke;
import android.graphics.RectF;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.FloatArrayAssert;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.ObjectAssert;

public class GestureStrokeAssert
extends AbstractAssert<GestureStrokeAssert, GestureStroke> {
    public GestureStrokeAssert(GestureStroke actual) {
        super((Object)actual, GestureStrokeAssert.class);
    }

    public GestureStrokeAssert hasBoundingBox(RectF rect) {
        this.isNotNull();
        RectF actualRect = ((GestureStroke)this.actual).boundingBox;
        ((ObjectAssert)Assertions.assertThat((Object)actualRect).overridingErrorMessage("Expected bounding box <%s> but was <%s>.", new Object[]{rect, actualRect})).isEqualTo((Object)rect);
        return this;
    }

    public GestureStrokeAssert hasLength(float length) {
        this.isNotNull();
        float actualLength = ((GestureStroke)this.actual).length;
        ((FloatAssert)Assertions.assertThat((float)actualLength).overridingErrorMessage("Expected length <%s> but was <%s>.", new Object[]{Float.valueOf(length), Float.valueOf(actualLength)})).isEqualTo(length);
        return this;
    }

    public GestureStrokeAssert hasPoints(float[] points) {
        this.isNotNull();
        float[] actualPoints = ((GestureStroke)this.actual).points;
        ((FloatArrayAssert)Assertions.assertThat((float[])actualPoints).overridingErrorMessage("Expected points <%s> but was <%s>.", new Object[]{points, actualPoints})).isEqualTo((Object)points);
        return this;
    }
}

