/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.text;

import com.google.common.base.Function;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.text.DefaultDocumentModel;
import com.simsilica.lemur.text.DocumentModel;
import java.util.Objects;

public class DocumentModelFilter
implements DocumentModel {
    private DocumentModel delegate;
    private Function<Character, Character> inputTransform;
    private Function<String, String> outputTransform;
    private String lastOutput = null;
    private String lastTransformedOutput = null;
    private long version;

    public DocumentModelFilter() {
        this(new DefaultDocumentModel());
    }

    public DocumentModelFilter(Function<Character, Character> inputTransform, Function<String, String> outputTransform) {
        this(new DefaultDocumentModel(), inputTransform, outputTransform);
    }

    public DocumentModelFilter(DocumentModel delegate) {
        this.delegate = delegate;
    }

    public DocumentModelFilter(DocumentModel delegate, Function<Character, Character> inputTransform, Function<String, String> outputTransform) {
        this.delegate = delegate;
        this.inputTransform = inputTransform;
        this.outputTransform = outputTransform;
    }

    public DocumentModel getDelegate() {
        return this.delegate;
    }

    public void setOutputTransform(Function<String, String> f) {
        if (this.outputTransform == f) {
            return;
        }
        this.outputTransform = f;
        ++this.version;
    }

    public Function<String, String> getOutputTransform() {
        return this.outputTransform;
    }

    public void setInputTransform(Function<Character, Character> f) {
        if (this.inputTransform == f) {
            return;
        }
        this.inputTransform = f;
        ++this.version;
    }

    public Function<Character, Character> getInputTransform() {
        return this.inputTransform;
    }

    @Override
    public DocumentModel clone() {
        return new DocumentModelFilter(this.delegate.clone());
    }

    protected String filterInput(String text) {
        if (this.inputTransform != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                Character x = (Character)this.inputTransform.apply((Object)Character.valueOf(c));
                if (x == null) continue;
                sb.append(x);
            }
            return sb.toString();
        }
        return text;
    }

    protected Character filterInput(char c) {
        if (this.inputTransform != null) {
            return (Character)this.inputTransform.apply((Object)Character.valueOf(c));
        }
        return Character.valueOf(c);
    }

    protected String filterOutput(String text) {
        if (this.outputTransform != null) {
            return (String)this.outputTransform.apply((Object)text);
        }
        return text;
    }

    @Override
    public void setText(String text) {
        this.delegate.setText(this.filterInput(text));
    }

    @Override
    public String getText() {
        String output = this.delegate.getText();
        if (Objects.equals(output, this.lastOutput)) {
            return this.lastTransformedOutput;
        }
        this.lastOutput = output;
        this.lastTransformedOutput = this.filterOutput(output);
        return this.lastTransformedOutput;
    }

    @Override
    public String getLine(int line) {
        return this.filterOutput(this.delegate.getLine(line));
    }

    @Override
    public int getLineCount() {
        return this.delegate.getLineCount();
    }

    @Override
    public int getCarat() {
        return this.delegate.getCarat();
    }

    @Override
    public int getCaratLine() {
        return this.delegate.getCaratLine();
    }

    @Override
    public int getCaratColumn() {
        return this.delegate.getCaratColumn();
    }

    @Override
    public int getAnchorLine() {
        return this.delegate.getAnchorLine();
    }

    @Override
    public int getAnchorColumn() {
        return this.delegate.getAnchorColumn();
    }

    @Override
    public int getAnchor() {
        return this.delegate.getAnchor();
    }

    @Override
    public int home(boolean currentLine) {
        return this.delegate.home(currentLine);
    }

    @Override
    public int end(boolean currentLine) {
        return this.delegate.end(currentLine);
    }

    @Override
    public int up() {
        return this.delegate.up();
    }

    @Override
    public int down() {
        return this.delegate.down();
    }

    @Override
    public int left() {
        return this.delegate.left();
    }

    @Override
    public int right() {
        return this.delegate.right();
    }

    @Override
    public void insertNewLine() {
        this.delegate.insertNewLine();
    }

    @Override
    public void deleteCharAt(int pos) {
        this.delegate.deleteCharAt(pos);
    }

    @Override
    public void backspace() {
        this.delegate.backspace();
    }

    @Override
    public void delete() {
        this.delegate.delete();
    }

    @Override
    public void insert(char c) {
        Character x = this.filterInput(c);
        if (x != null) {
            this.delegate.insert(x.charValue());
        }
    }

    @Override
    public void insert(String text) {
        for (int i = 0; i < text.length(); ++i) {
            this.insert(text.charAt(i));
        }
    }

    @Override
    public long getVersion() {
        return this.delegate.getVersion() + this.version;
    }

    @Override
    public DocumentModel getObject() {
        return this;
    }

    @Override
    public VersionedReference<DocumentModel> createReference() {
        return new VersionedReference<DocumentModel>(this);
    }

    @Override
    public VersionedReference<Integer> createCaratReference() {
        return this.delegate.createCaratReference();
    }
}

