/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.style;

import com.simsilica.lemur.style.Styles;
import java.util.HashMap;
import java.util.Map;

public class Attributes {
    private Styles parent;
    private Map<String, Object> values = new HashMap<String, Object>();

    public Attributes(Styles parent) {
        this.parent = parent;
    }

    protected Map<String, Object> getValues() {
        return this.values;
    }

    protected void applyNew(Attributes atts) {
        for (Map.Entry<String, Object> e : atts.values.entrySet()) {
            Object existing = this.values.get(e.getKey());
            if (existing instanceof Map && e.getValue() instanceof Map) {
                this.values.put(e.getKey(), this.mergeMap((Map)existing, (Map)e.getValue()));
                continue;
            }
            if (existing != null || this.values.containsKey(e.getKey())) continue;
            this.values.put(e.getKey(), e.getValue());
        }
    }

    protected Map mergeMap(Map high, Map low) {
        HashMap result = new HashMap();
        result.putAll(high);
        for (Map.Entry o : low.entrySet()) {
            Map.Entry e = o;
            if (result.containsKey(e.getKey())) continue;
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    protected Attributes merge(Attributes atts) {
        if (atts.isEmpty()) {
            return this;
        }
        Attributes result = new Attributes(this.parent);
        result.values.putAll(this.values);
        result.applyNew(atts);
        return result;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public boolean hasAttribute(String key) {
        return this.values.containsKey(key);
    }

    public void set(String attribute, Object value) {
        this.set(attribute, value, true);
    }

    public void set(String attribute, Object value, boolean overwrite) {
        if (!overwrite && this.values.containsKey(attribute)) {
            return;
        }
        this.values.put(attribute, value);
    }

    public <T> T get(String attribute) {
        return (T)this.values.get(attribute);
    }

    public <T> T get(String attribute, Class<T> type) {
        return this.get(attribute, type, true);
    }

    public <T> T get(String attribute, Class<T> type, boolean lookupDefault) {
        Object result = this.values.get(attribute);
        if (result == null && lookupDefault) {
            result = this.parent.getDefault(type);
        }
        return (T)result;
    }

    public String toString() {
        return "Attributes[" + this.values + "]";
    }
}

