/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.geom;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class MBox
extends Mesh
implements Savable,
Cloneable {
    public static final int TOP_MASK = 1;
    public static final int BOTTOM_MASK = 2;
    public static final int FRONT_MASK = 4;
    public static final int BACK_MASK = 8;
    public static final int LEFT_MASK = 16;
    public static final int RIGHT_MASK = 32;
    public static final int ALL_MASK = 63;
    private static final int TOP = 0;
    private static final int BOTTOM = 1;
    private static final int FRONT = 2;
    private static final int BACK = 3;
    private static final int LEFT = 4;
    private static final int RIGHT = 5;
    private static Vector3f[] normals = new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f)};
    private static Vector3f[] tangents = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, -1.0f)};
    private static Vector3f[] binormals = new Vector3f[]{new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)};
    private Vector3f extents = new Vector3f();
    private int[] slices = new int[3];
    private int sideMask;

    public MBox() {
    }

    public MBox(float xExtent, float yExtent, float zExtent, int xSlices, int ySlices, int zSlices) {
        this(xExtent, yExtent, zExtent, xSlices, ySlices, zSlices, 63);
    }

    public MBox(float xExtent, float yExtent, float zExtent, int xSlices, int ySlices, int zSlices, int sideMask) {
        this.sideMask = sideMask;
        this.extents.set(xExtent, yExtent, zExtent);
        this.slices[0] = xSlices;
        this.slices[1] = ySlices;
        this.slices[2] = zSlices;
        this.refreshGeometry();
    }

    public Vector3f getExtents() {
        return this.extents;
    }

    public void resize(Vector3f extents) {
        this.extents.set(extents);
        this.refreshGeometry();
    }

    public MBox clone() {
        MBox result = (MBox)super.deepClone();
        result.extents = this.extents.clone();
        result.slices = (int[])this.slices.clone();
        return result;
    }

    protected void refreshGeometry() {
        int xVertCount = this.slices[0] + 2;
        int yVertCount = this.slices[1] + 2;
        int zVertCount = this.slices[2] + 2;
        int xQuadCount = this.slices[0] + 1;
        int yQuadCount = this.slices[1] + 1;
        int zQuadCount = this.slices[2] + 1;
        int upVertCount = xVertCount * zVertCount;
        int frontVertCount = xVertCount * yVertCount;
        int sideVertCount = zVertCount * yVertCount;
        int upTriCount = xQuadCount * zQuadCount * 2;
        int frontTriCount = xQuadCount * yQuadCount * 2;
        int sideTriCount = zQuadCount * yQuadCount * 2;
        int vertCount = 0;
        int triCount = 0;
        if ((this.sideMask & 1) != 0) {
            vertCount += upVertCount;
            triCount += upTriCount;
        }
        if ((this.sideMask & 2) != 0) {
            vertCount += upVertCount;
            triCount += upTriCount;
        }
        if ((this.sideMask & 4) != 0) {
            vertCount += frontVertCount;
            triCount += frontTriCount;
        }
        if ((this.sideMask & 8) != 0) {
            vertCount += frontVertCount;
            triCount += frontTriCount;
        }
        if ((this.sideMask & 0x10) != 0) {
            vertCount += sideVertCount;
            triCount += sideTriCount;
        }
        if ((this.sideMask & 0x20) != 0) {
            vertCount += sideVertCount;
            triCount += sideTriCount;
        }
        FloatBuffer verts = BufferUtils.createFloatBuffer((int)(vertCount * 3));
        FloatBuffer norms = BufferUtils.createFloatBuffer((int)(vertCount * 3));
        FloatBuffer texes = BufferUtils.createFloatBuffer((int)(vertCount * 2));
        ShortBuffer index = BufferUtils.createShortBuffer((int)(triCount * 3));
        int lastIndex = 0;
        if ((this.sideMask & 1) != 0) {
            lastIndex = this.fillSide(lastIndex, 0, 0, xVertCount, 2, zVertCount, 1, verts, norms, texes, index);
        }
        if ((this.sideMask & 2) != 0) {
            lastIndex = this.fillSide(lastIndex, 1, 0, xVertCount, 2, zVertCount, 1, verts, norms, texes, index);
        }
        if ((this.sideMask & 4) != 0) {
            lastIndex = this.fillSide(lastIndex, 2, 0, xVertCount, 1, yVertCount, 2, verts, norms, texes, index);
        }
        if ((this.sideMask & 8) != 0) {
            lastIndex = this.fillSide(lastIndex, 3, 0, xVertCount, 1, yVertCount, 2, verts, norms, texes, index);
        }
        if ((this.sideMask & 0x10) != 0) {
            lastIndex = this.fillSide(lastIndex, 4, 2, zVertCount, 1, yVertCount, 0, verts, norms, texes, index);
        }
        if ((this.sideMask & 0x20) != 0) {
            lastIndex = this.fillSide(lastIndex, 5, 2, zVertCount, 1, yVertCount, 0, verts, norms, texes, index);
        }
        index.flip();
        norms.flip();
        verts.flip();
        texes.flip();
        this.setBuffer(VertexBuffer.Type.Index, 3, index);
        this.setBuffer(VertexBuffer.Type.Position, 3, verts);
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, texes);
        this.setBuffer(VertexBuffer.Type.Normal, 3, norms);
        this.updateBound();
        this.clearCollisionData();
    }

    protected float[] spread(float min, float max, int count) {
        float[] result = new float[count];
        float delta = max - min;
        float step = 1.0f / (float)(count - 1);
        for (int i = 0; i < count; ++i) {
            result[i] = min + delta * (float)i * step;
        }
        return result;
    }

    protected int fillSide(int lastIndex, int side, int colAxis, int colCount, int rowAxis, int rowCount, int otherAxis, FloatBuffer verts, FloatBuffer norms, FloatBuffer texes, ShortBuffer index) {
        Vector3f normal = normals[side];
        Vector3f tangent = tangents[side];
        Vector3f binormal = binormals[side];
        float rowMin = binormal.get(rowAxis) * -this.extents.get(rowAxis);
        float rowMax = binormal.get(rowAxis) * this.extents.get(rowAxis);
        float colMin = tangent.get(colAxis) * -this.extents.get(colAxis);
        float colMax = tangent.get(colAxis) * this.extents.get(colAxis);
        float[] rowVals = this.spread(rowMin, rowMax, rowCount);
        float[] colVals = this.spread(colMin, colMax, colCount);
        Vector3f pos = new Vector3f();
        pos.set(otherAxis, normal.get(otherAxis) * this.extents.get(otherAxis));
        int lastBaseIndex = 0;
        for (int j = 0; j < rowCount; ++j) {
            pos.set(rowAxis, rowVals[j]);
            int baseIndex = lastIndex + j * colCount;
            for (int i = 0; i < colCount; ++i) {
                pos.set(colAxis, colVals[i]);
                verts.put(pos.x);
                verts.put(pos.y);
                verts.put(pos.z);
                norms.put(normal.x);
                norms.put(normal.y);
                norms.put(normal.z);
                texes.put((float)i / (float)(colCount - 1));
                texes.put((float)j / (float)(rowCount - 1));
                if (j <= 0 || i >= colCount - 1) continue;
                index.put((short)lastBaseIndex);
                index.put((short)(lastBaseIndex + 1));
                index.put((short)(baseIndex + 1));
                index.put((short)lastBaseIndex);
                index.put((short)(baseIndex + 1));
                index.put((short)baseIndex);
                ++baseIndex;
                ++lastBaseIndex;
            }
            lastBaseIndex = lastIndex + j * colCount;
        }
        return lastIndex + colCount * rowCount;
    }

    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule ic = e.getCapsule((Savable)this);
        this.extents = (Vector3f)ic.readSavable("extents", null);
        this.slices = ic.readIntArray("slices", null);
        this.sideMask = ic.readInt("sideMask", 0);
    }

    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule oc = e.getCapsule((Savable)this);
        oc.write((Savable)this.extents, "extents", null);
        oc.write(this.slices, "slices", null);
        oc.write(this.sideMask, "sideMask", 0);
    }
}

