/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.geom;

import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.simsilica.lemur.geom.Deformation;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class DMesh
extends Mesh {
    private Mesh mesh;
    private Deformation deform;

    public DMesh(Mesh mesh) {
        this.mesh = mesh;
    }

    public DMesh(Mesh mesh, Deformation deform) {
        this.mesh = mesh;
        this.deform = deform;
        this.updateMesh();
    }

    protected VertexBuffer matchBuffer(VertexBuffer source) {
        if (source == null) {
            return null;
        }
        VertexBuffer target = this.getBuffer(source.getBufferType());
        if (target == null || target.getData().capacity() < source.getData().limit()) {
            target = source.clone();
            this.setBuffer(target);
        } else {
            target.getData().limit(source.getData().limit());
        }
        return target;
    }

    public void setDeformation(Deformation deform) {
        this.deform = deform;
        this.updateMesh();
    }

    public Deformation getDeformation() {
        return this.deform;
    }

    public void updateMesh() {
        VertexBuffer sourcePos = this.mesh.getBuffer(VertexBuffer.Type.Position);
        VertexBuffer sourceNorms = this.mesh.getBuffer(VertexBuffer.Type.Normal);
        VertexBuffer targetPos = this.matchBuffer(sourcePos);
        VertexBuffer targetNorms = this.matchBuffer(sourceNorms);
        this.matchBuffer(this.mesh.getBuffer(VertexBuffer.Type.Index));
        this.matchBuffer(this.mesh.getBuffer(VertexBuffer.Type.TexCoord));
        this.morph(sourcePos, sourceNorms, targetPos, targetNorms);
        this.updateBound();
    }

    protected void morph(VertexBuffer sourcePos, VertexBuffer sourceNorms, VertexBuffer targetPos, VertexBuffer targetNorms) {
        FloatBuffer sp = (FloatBuffer)sourcePos.getData();
        sp.rewind();
        FloatBuffer sn = (FloatBuffer)sourceNorms.getData();
        sn.rewind();
        FloatBuffer tp = (FloatBuffer)targetPos.getData();
        tp.rewind();
        FloatBuffer tn = (FloatBuffer)targetNorms.getData();
        tn.rewind();
        this.morph(sp, sn, tp, tn);
        sp.rewind();
        sn.rewind();
        tp.rewind();
        targetPos.updateData((Buffer)tp);
        tn.rewind();
        targetNorms.updateData((Buffer)tn);
    }

    protected void morph(FloatBuffer sourcePos, FloatBuffer sourceNorms, FloatBuffer targetPos, FloatBuffer targetNorms) {
        if (this.deform == null) {
            return;
        }
        int count = sourcePos.limit() / 3;
        Vector3f v = new Vector3f();
        Vector3f normal = new Vector3f();
        for (int i = 0; i < count; ++i) {
            v.x = sourcePos.get();
            v.y = sourcePos.get();
            v.z = sourcePos.get();
            normal.x = sourceNorms.get();
            normal.y = sourceNorms.get();
            normal.z = sourceNorms.get();
            this.morphVertex(v, normal);
            targetPos.put(v.x).put(v.y).put(v.z);
            targetNorms.put(normal.x).put(normal.y).put(normal.z);
        }
    }

    protected void morphVertex(Vector3f vert, Vector3f normal) {
        this.deform.deform(vert, normal);
    }
}

